/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class HashJoinExec
extends UnaryExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "HashJoinExec", HashJoinExec::new);
    private final LocalSourceExec joinData;
    private final List<Attribute> matchFields;
    private final List<Attribute> leftFields;
    private final List<Attribute> rightFields;
    private final List<Attribute> output;
    private AttributeSet lazyAddedFields;

    public HashJoinExec(Source source, PhysicalPlan child, LocalSourceExec hashData, List<Attribute> matchFields, List<Attribute> leftFields, List<Attribute> rightFields, List<Attribute> output) {
        super(source, child);
        this.joinData = hashData;
        this.matchFields = matchFields;
        this.leftFields = leftFields;
        this.rightFields = rightFields;
        this.output = output;
    }

    private HashJoinExec(StreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)((PlanStreamInput)in)), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class));
        this.joinData = new LocalSourceExec(in);
        this.matchFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.leftFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.rightFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.output = in.readNamedWriteableCollectionAsList(Attribute.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        this.joinData.writeTo(out);
        out.writeNamedWriteableCollection(this.matchFields);
        out.writeNamedWriteableCollection(this.leftFields);
        out.writeNamedWriteableCollection(this.rightFields);
        out.writeNamedWriteableCollection(this.output);
    }

    public String getWriteableName() {
        return HashJoinExec.ENTRY.name;
    }

    public LocalSourceExec joinData() {
        return this.joinData;
    }

    public List<Attribute> matchFields() {
        return this.matchFields;
    }

    public List<Attribute> leftFields() {
        return this.leftFields;
    }

    public List<Attribute> rightFields() {
        return this.rightFields;
    }

    public Set<Attribute> addedFields() {
        if (this.lazyAddedFields == null) {
            this.lazyAddedFields = this.outputSet();
            this.lazyAddedFields.removeAll(this.child().output());
        }
        return this.lazyAddedFields;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.output);
        return this;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    protected AttributeSet computeReferences() {
        return Expressions.references(this.leftFields);
    }

    @Override
    public HashJoinExec replaceChild(PhysicalPlan newChild) {
        return new HashJoinExec(this.source(), newChild, this.joinData, this.matchFields, this.leftFields, this.rightFields, this.output);
    }

    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create((Node)this, HashJoinExec::new, (Object)((Object)this.child()), (Object)((Object)this.joinData), this.matchFields, this.leftFields, this.rightFields, this.output);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HashJoinExec hash = (HashJoinExec)o;
        return this.joinData.equals((Object)hash.joinData) && this.matchFields.equals(hash.matchFields) && this.leftFields.equals(hash.leftFields) && this.rightFields.equals(hash.rightFields) && this.output.equals(hash.output);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.joinData, this.matchFields, this.leftFields, this.rightFields, this.output});
    }
}

