/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Queries;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class EsStatsQueryExec
extends LeafExec
implements EstimatesRowSize {
    private final EsIndex index;
    private final QueryBuilder query;
    private final Expression limit;
    private final List<Attribute> attrs;
    private final List<Stat> stats;

    public EsStatsQueryExec(Source source, EsIndex index, QueryBuilder query, Expression limit, List<Attribute> attributes, List<Stat> stats) {
        super(source);
        this.index = index;
        this.query = query;
        this.limit = limit;
        this.attrs = attributes;
        this.stats = stats;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    protected NodeInfo<EsStatsQueryExec> info() {
        return NodeInfo.create((Node)this, EsStatsQueryExec::new, (Object)this.index, (Object)this.query, (Object)this.limit, this.attrs, this.stats);
    }

    public EsIndex index() {
        return this.index;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public List<Stat> stats() {
        return this.stats;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.attrs);
        int size = state.consumeAllFields(false);
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.query, this.limit, this.attrs, this.stats);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsStatsQueryExec other = (EsStatsQueryExec)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.attrs, other.attrs) && Objects.equals(this.query, other.query) && Objects.equals(this.limit, other.limit) && Objects.equals(this.stats, other.stats);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.index + "], stats" + this.stats + "], query[" + (this.query != null ? Strings.toString((ToXContent)this.query, (boolean)false, (boolean)true) : "") + "]" + NodeUtils.limitedToString(this.attrs) + ", limit[" + (this.limit != null ? this.limit.toString() : "") + "], ";
    }

    public record Stat(String name, StatsType type, QueryBuilder query) {
        public QueryBuilder filter(QueryBuilder sourceQuery) {
            return this.query == null ? sourceQuery : Queries.combine((Queries.Clause)Queries.Clause.FILTER, Arrays.asList(sourceQuery, this.query));
        }
    }

    public static enum StatsType {
        COUNT,
        MIN,
        MAX,
        EXISTS;

    }
}

