/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class EsSourceExec
extends LeafExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "EsSourceExec", EsSourceExec::new);
    private final EsIndex index;
    private final List<Attribute> attributes;
    private final QueryBuilder query;
    private final IndexMode indexMode;

    public EsSourceExec(EsRelation relation) {
        this(relation.source(), relation.index(), relation.output(), null, relation.indexMode());
    }

    public EsSourceExec(Source source, EsIndex index, List<Attribute> attributes, QueryBuilder query, IndexMode indexMode) {
        super(source);
        this.index = index;
        this.attributes = attributes;
        this.query = query;
        this.indexMode = indexMode;
    }

    private EsSourceExec(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), new EsIndex(in), in.readNamedWriteableCollectionAsList(Attribute.class), (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class), EsRelation.readIndexMode(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        this.index().writeTo(out);
        out.writeNamedWriteableCollection(this.output());
        out.writeOptionalNamedWriteable((NamedWriteable)this.query());
        EsRelation.writeIndexMode(out, this.indexMode());
    }

    public String getWriteableName() {
        return EsSourceExec.ENTRY.name;
    }

    public EsIndex index() {
        return this.index;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    @Override
    public List<Attribute> output() {
        return this.attributes;
    }

    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create((Node)this, EsSourceExec::new, (Object)this.index, this.attributes, (Object)this.query, (Object)this.indexMode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.attributes, this.query, this.indexMode);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EsSourceExec other = (EsSourceExec)((Object)obj);
        return Objects.equals(this.index, other.index) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.query, other.query) && Objects.equals(this.indexMode, other.indexMode);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.index + "]" + NodeUtils.limitedToString(this.attributes);
    }
}

