/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.local;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;

public class LocalRelation
extends LeafPlan {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "LocalRelation", LocalRelation::new);
    private final List<Attribute> output;
    private final LocalSupplier supplier;

    public LocalRelation(Source source, List<Attribute> output, LocalSupplier supplier) {
        super(source);
        this.output = output;
        this.supplier = supplier;
    }

    public LocalRelation(StreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)((PlanStreamInput)in)));
        this.output = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.supplier = LocalSupplier.readFrom((PlanStreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteableCollection(this.output);
        this.supplier.writeTo(out);
    }

    public String getWriteableName() {
        return LocalRelation.ENTRY.name;
    }

    protected NodeInfo<LocalRelation> info() {
        return NodeInfo.create((Node)this, LocalRelation::new, this.output, (Object)this.supplier);
    }

    public LocalSupplier supplier() {
        return this.supplier;
    }

    @Override
    public String commandName() {
        return "<local relation>";
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.output, this.supplier);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LocalRelation other = (LocalRelation)((Object)obj);
        return Objects.equals(this.supplier, other.supplier) && Objects.equals(this.output, other.output);
    }
}

