/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.List;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public interface Phased {
    public LogicalPlan firstPhase();

    public LogicalPlan nextPhase(List<Attribute> var1, List<Page> var2);

    public static LogicalPlan extractFirstPhase(LogicalPlan plan) {
        if (!plan.optimized()) {
            throw new IllegalArgumentException("plan must be optimized");
        }
        Holder firstPhase = new Holder();
        plan.forEachUp(t -> {
            if (firstPhase.get() == null && t instanceof Phased) {
                Phased phased = (Phased)((Object)t);
                firstPhase.set((Object)phased.firstPhase());
            }
        });
        LogicalPlan firstPhasePlan = (LogicalPlan)((Object)firstPhase.get());
        if (firstPhasePlan != null) {
            firstPhasePlan.setAnalyzed();
        }
        return firstPhasePlan;
    }

    public static LogicalPlan applyResultsFromFirstPhase(LogicalPlan plan, List<Attribute> schema, List<Page> result) {
        if (!plan.analyzed()) {
            throw new IllegalArgumentException("plan must be analyzed");
        }
        Holder seen = new Holder((Object)false);
        LogicalPlan applied = (LogicalPlan)plan.transformUp(logicalPlan -> {
            if (!((Boolean)seen.get()).booleanValue() && logicalPlan instanceof Phased) {
                Phased phased = (Phased)((Object)logicalPlan);
                seen.set((Object)true);
                return phased.nextPhase(schema, result);
            }
            return logicalPlan;
        });
        applied.setAnalyzed();
        return applied;
    }
}

