/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;

public class Lookup
extends UnaryPlan {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Lookup", Lookup::new);
    private final Expression tableName;
    private final List<Attribute> matchFields;
    private final LocalRelation localRelation;
    private List<Attribute> lazyOutput;

    public Lookup(Source source, LogicalPlan child, Expression tableName, List<Attribute> matchFields, @Nullable LocalRelation localRelation) {
        super(source, child);
        this.tableName = tableName;
        this.matchFields = matchFields;
        this.localRelation = localRelation;
    }

    public Lookup(StreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class));
        this.tableName = (Expression)in.readNamedWriteable(Expression.class);
        this.matchFields = in.readNamedWriteableCollectionAsList(Attribute.class);
        this.localRelation = in.readBoolean() ? new LocalRelation(in) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.tableName);
        out.writeNamedWriteableCollection(this.matchFields);
        if (this.localRelation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.localRelation.writeTo(out);
        }
    }

    public String getWriteableName() {
        return Lookup.ENTRY.name;
    }

    public Expression tableName() {
        return this.tableName;
    }

    public List<Attribute> matchFields() {
        return this.matchFields;
    }

    public LocalRelation localRelation() {
        return this.localRelation;
    }

    public JoinConfig joinConfig() {
        ArrayList<Attribute> leftFields = new ArrayList<Attribute>(this.matchFields.size());
        ArrayList<Attribute> rightFields = new ArrayList<Attribute>(this.matchFields.size());
        List<Attribute> rhsOutput = Join.makeReference(this.localRelation.output());
        block0: for (Attribute lhs : this.matchFields) {
            for (Attribute rhs : rhsOutput) {
                if (!lhs.name().equals(rhs.name())) continue;
                leftFields.add(lhs);
                rightFields.add(rhs);
                continue block0;
            }
        }
        return new JoinConfig(JoinType.LEFT, this.matchFields, leftFields, rightFields);
    }

    @Override
    protected AttributeSet computeReferences() {
        return new AttributeSet(this.matchFields);
    }

    @Override
    public String commandName() {
        return "LOOKUP";
    }

    @Override
    public boolean expressionsResolved() {
        return this.tableName.resolved() && Resolvables.resolved(this.matchFields) && this.localRelation != null;
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Lookup(this.source(), newChild, this.tableName, this.matchFields, this.localRelation);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Lookup::new, (Object)((Object)this.child()), (Object)this.tableName, this.matchFields, (Object)((Object)this.localRelation));
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            if (this.localRelation == null) {
                throw new IllegalStateException("Cannot determine output of LOOKUP with unresolved table");
            }
            this.lazyOutput = Join.computeOutput(this.child().output(), this.localRelation.output(), this.joinConfig());
        }
        return this.lazyOutput;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Lookup lookup = (Lookup)((Object)o);
        return Objects.equals(this.tableName, lookup.tableName) && Objects.equals(this.matchFields, lookup.matchFields) && Objects.equals((Object)this.localRelation, (Object)lookup.localRelation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.tableName, this.matchFields, this.localRelation});
    }
}

