/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Phased;
import org.elasticsearch.xpack.esql.plan.logical.Stats;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class InlineStats
extends UnaryPlan
implements NamedWriteable,
Phased,
Stats {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "InlineStats", InlineStats::new);
    private final List<Expression> groupings;
    private final List<? extends NamedExpression> aggregates;
    private List<Attribute> lazyOutput;

    public InlineStats(Source source, LogicalPlan child, List<Expression> groupings, List<? extends NamedExpression> aggregates) {
        super(source, child);
        this.groupings = groupings;
        this.aggregates = aggregates;
    }

    public InlineStats(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), in.readNamedWriteableCollectionAsList(Expression.class), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteableCollection(this.groupings);
        out.writeNamedWriteableCollection(this.aggregates);
    }

    public String getWriteableName() {
        return InlineStats.ENTRY.name;
    }

    protected NodeInfo<InlineStats> info() {
        return NodeInfo.create((Node)this, InlineStats::new, (Object)((Object)this.child()), this.groupings, this.aggregates);
    }

    @Override
    public InlineStats replaceChild(LogicalPlan newChild) {
        return new InlineStats(this.source(), newChild, this.groupings, this.aggregates);
    }

    @Override
    public InlineStats with(LogicalPlan child, List<Expression> newGroupings, List<? extends NamedExpression> newAggregates) {
        return new InlineStats(this.source(), child, newGroupings, newAggregates);
    }

    @Override
    public List<Expression> groupings() {
        return this.groupings;
    }

    @Override
    public List<? extends NamedExpression> aggregates() {
        return this.aggregates;
    }

    @Override
    public String commandName() {
        return "INLINESTATS";
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.groupings) && Resolvables.resolved(this.aggregates);
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            ArrayList<NamedExpression> addedFields = new ArrayList<NamedExpression>();
            AttributeSet set = this.child().outputSet();
            for (NamedExpression namedExpression : this.aggregates) {
                Attribute att = namedExpression.toAttribute();
                if (set.contains((Object)att)) continue;
                addedFields.add(namedExpression);
                set.add(att);
            }
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(addedFields, this.child().output());
        }
        return this.lazyOutput;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.groupings, this.aggregates, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InlineStats other = (InlineStats)obj;
        return Objects.equals(this.groupings, other.groupings) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals((Object)this.child(), (Object)other.child());
    }

    @Override
    public LogicalPlan firstPhase() {
        return new Aggregate(this.source(), this.child(), Aggregate.AggregateType.STANDARD, this.groupings, this.aggregates);
    }

    @Override
    public LogicalPlan nextPhase(List<Attribute> schema, List<Page> firstPhaseResult) {
        if (!InlineStats.equalsAndSemanticEquals(this.firstPhase().output(), schema)) {
            throw new IllegalStateException("Unexpected first phase outputs: " + this.firstPhase().output() + " vs " + schema);
        }
        if (this.groupings.isEmpty()) {
            return this.ungroupedNextPhase(schema, firstPhaseResult);
        }
        return this.groupedNextPhase(schema, firstPhaseResult);
    }

    private LogicalPlan ungroupedNextPhase(List<Attribute> schema, List<Page> firstPhaseResult) {
        if (firstPhaseResult.size() != 1) {
            throw new IllegalArgumentException("expected single row");
        }
        Page p = firstPhaseResult.get(0);
        if (p.getPositionCount() != 1) {
            throw new IllegalArgumentException("expected single row");
        }
        ArrayList<Alias> values = new ArrayList<Alias>(schema.size());
        for (int i = 0; i < schema.size(); ++i) {
            Attribute s = schema.get(i);
            Object value = BlockUtils.toJavaObject((Block)p.getBlock(i), (int)0);
            values.add(new Alias(this.source(), s.name(), (Expression)new Literal(this.source(), value, s.dataType()), this.aggregates.get(i).id()));
        }
        return new Eval(this.source(), this.child(), values);
    }

    private static boolean equalsAndSemanticEquals(List<Attribute> left, List<Attribute> right) {
        if (!left.equals(right)) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (left.get(i).semanticEquals((Expression)right.get(i))) continue;
            return false;
        }
        return true;
    }

    private LogicalPlan groupedNextPhase(List<Attribute> schema, List<Page> firstPhaseResult) {
        LocalRelation local = this.firstPhaseResultsToLocalRelation(schema, firstPhaseResult);
        ArrayList<Attribute> groupingAttributes = new ArrayList<Attribute>(this.groupings.size());
        for (Expression g : this.groupings) {
            if (g instanceof Attribute) {
                Attribute a = (Attribute)g;
                groupingAttributes.add(a);
                continue;
            }
            throw new IllegalStateException("optimized plans should only have attributes in groups, but got [" + g + "]");
        }
        ArrayList<Attribute> leftFields = new ArrayList<Attribute>(groupingAttributes.size());
        ArrayList<Attribute> rightFields = new ArrayList<Attribute>(groupingAttributes.size());
        List<Attribute> rhsOutput = Join.makeReference(local.output());
        block1: for (Attribute lhs : groupingAttributes) {
            for (Attribute rhs : rhsOutput) {
                if (!lhs.name().equals(rhs.name())) continue;
                leftFields.add(lhs);
                rightFields.add(rhs);
                continue block1;
            }
        }
        JoinConfig config = new JoinConfig(JoinType.LEFT, groupingAttributes, leftFields, rightFields);
        return new Join(this.source(), this.child(), local, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalRelation firstPhaseResultsToLocalRelation(List<Attribute> schema, List<Page> firstPhaseResult) {
        Block[] blocks;
        long bytesUsed = firstPhaseResult.stream().mapToLong(Page::ramBytesUsedByBlocks).sum();
        if (bytesUsed > ByteSizeValue.ofMb((long)1L).getBytes()) {
            throw new IllegalArgumentException("first phase result too large [" + ByteSizeValue.ofBytes((long)bytesUsed) + "] > 1mb");
        }
        int positionCount = firstPhaseResult.stream().mapToInt(Page::getPositionCount).sum();
        Block.Builder[] builders = new Block.Builder[schema.size()];
        try {
            for (int b = 0; b < builders.length; ++b) {
                builders[b] = PlannerUtils.toElementType(schema.get(b).dataType()).newBlockBuilder(positionCount, PlannerUtils.NON_BREAKING_BLOCK_FACTORY);
            }
            for (Page p : firstPhaseResult) {
                for (int b = 0; b < builders.length; ++b) {
                    builders[b].copyFrom(p.getBlock(b), 0, p.getPositionCount());
                }
            }
            blocks = Block.Builder.buildAll((Block.Builder[])builders);
        }
        finally {
            Releasables.closeExpectNoException((Releasable[])builders);
        }
        return new LocalRelation(this.source(), schema, LocalSupplier.of(blocks));
    }
}

