/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.Token;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.QueryParam;

public class QueryParams {
    private final List<QueryParam> params;
    private final Map<String, QueryParam> nameToParam;
    private Map<Token, QueryParam> tokenToParam = new HashMap<Token, QueryParam>();
    private List<ParsingException> parsingErrors = new ArrayList<ParsingException>();
    private final int paramsCount;

    public QueryParams() {
        this(null);
    }

    public QueryParams(List<QueryParam> params) {
        if (params == null || params.isEmpty()) {
            this.params = List.of();
            this.nameToParam = Map.of();
            this.paramsCount = 0;
        } else {
            this.paramsCount = params.size();
            this.params = new ArrayList<QueryParam>(this.paramsCount);
            HashMap<String, QueryParam> tempNameToParam = new HashMap<String, QueryParam>(this.paramsCount);
            for (QueryParam p : params) {
                this.params.add(p);
                String name = p.name();
                if (name == null) continue;
                tempNameToParam.put(name, p);
            }
            this.nameToParam = Collections.unmodifiableMap(tempNameToParam);
        }
    }

    public int size() {
        return this.paramsCount;
    }

    public QueryParam get(int index) {
        return index <= 0 || index > this.paramsCount ? null : this.params.get(index - 1);
    }

    public Map<String, QueryParam> namedParams() {
        return this.nameToParam;
    }

    public boolean contains(String paramName) {
        return this.nameToParam.containsKey(paramName);
    }

    public QueryParam get(String paramName) {
        return this.nameToParam.get(paramName);
    }

    public boolean contains(Token token) {
        return this.tokenToParam.containsKey(token);
    }

    public QueryParam get(Token tokenLocation) {
        return this.tokenToParam.get(tokenLocation);
    }

    public void addTokenParam(Token token, QueryParam param) {
        this.tokenToParam.put(token, param);
    }

    public Iterator<ParsingException> parsingErrors() {
        return this.parsingErrors.iterator();
    }

    public void addParsingError(ParsingException e) {
        this.parsingErrors.add(e);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParams that = (QueryParams)o;
        return this.paramsCount == that.paramsCount && this.params.equals(that.params) && this.nameToParam.equals(that.nameToParam) && this.tokenToParam.equals(that.tokenToParam) && this.parsingErrors.equals(that.parsingErrors);
    }

    public int hashCode() {
        return Objects.hash(this.params, this.nameToParam, this.tokenToParam, this.parsingErrors, this.paramsCount);
    }
}

