/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.Build;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.dissect.DissectException;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.tree.Location;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.esql.parser.ParserUtils;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.QueryParams;
import org.elasticsearch.xpack.esql.plan.TableIdentifier;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Explain;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Lookup;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowInfo;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.joni.exception.SyntaxException;

public class LogicalPlanBuilder
extends ExpressionBuilder {
    private int queryDepth = 0;
    public static final int MAX_QUERY_DEPTH = 500;

    public LogicalPlanBuilder(QueryParams params) {
        super(params);
    }

    protected LogicalPlan plan(ParseTree ctx) {
        LogicalPlan p = ParserUtils.typedParsing(this, ctx, LogicalPlan.class);
        Iterator<ParsingException> errors = this.params.parsingErrors();
        if (!errors.hasNext()) {
            return p;
        }
        StringBuilder message = new StringBuilder();
        int i = 0;
        while (errors.hasNext()) {
            if (i > 0) {
                message.append("; ");
            }
            message.append(errors.next().getMessage());
            ++i;
        }
        throw new ParsingException(message.toString(), new Object[0]);
    }

    protected List<LogicalPlan> plans(List<? extends ParserRuleContext> ctxs) {
        return ParserUtils.visitList(this, ctxs, LogicalPlan.class);
    }

    @Override
    public LogicalPlan visitSingleStatement(EsqlBaseParser.SingleStatementContext ctx) {
        return this.plan((ParseTree)ctx.query());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogicalPlan visitCompositeQuery(EsqlBaseParser.CompositeQueryContext ctx) {
        ++this.queryDepth;
        if (this.queryDepth > 500) {
            throw new ParsingException("ESQL statement exceeded the maximum query depth allowed ({}): [{}]", 500, ctx.getText());
        }
        try {
            LogicalPlan input = this.plan((ParseTree)ctx.query());
            PlanFactory makePlan = ParserUtils.typedParsing(this, (ParseTree)ctx.processingCommand(), PlanFactory.class);
            LogicalPlan logicalPlan = (LogicalPlan)((Object)makePlan.apply(input));
            return logicalPlan;
        }
        finally {
            --this.queryDepth;
        }
    }

    @Override
    public PlanFactory visitEvalCommand(EsqlBaseParser.EvalCommandContext ctx) {
        return p -> new Eval(ParserUtils.source(ctx), (LogicalPlan)((Object)p), (List<Alias>)this.visitFields(ctx.fields()));
    }

    @Override
    public PlanFactory visitGrokCommand(EsqlBaseParser.GrokCommandContext ctx) {
        return p -> {
            Grok.Parser grokParser;
            Source source = ParserUtils.source(ctx);
            String pattern = this.visitString(ctx.string()).fold().toString();
            try {
                grokParser = Grok.pattern(source, pattern);
            }
            catch (SyntaxException e) {
                throw new ParsingException(source, "Invalid grok pattern [{}]: [{}]", pattern, e.getMessage());
            }
            this.validateGrokPattern(source, grokParser, pattern);
            Grok result = new Grok(ParserUtils.source(ctx), (LogicalPlan)((Object)p), this.expression((ParseTree)ctx.primaryExpression()), grokParser);
            return result;
        };
    }

    private void validateGrokPattern(Source source, Grok.Parser grokParser, String pattern) {
        HashMap<String, DataType> definedAttributes = new HashMap<String, DataType>();
        for (Attribute field : grokParser.extractedFields()) {
            DataType type;
            String name = field.name();
            DataType prev = definedAttributes.put(name, type = field.dataType());
            if (prev == null) continue;
            throw new ParsingException(source, "Invalid GROK pattern [" + pattern + "]: the attribute [" + name + "] is defined multiple times with different types", new Object[0]);
        }
    }

    @Override
    public PlanFactory visitDissectCommand(EsqlBaseParser.DissectCommandContext ctx) {
        return p -> {
            String pattern = this.visitString(ctx.string()).fold().toString();
            Object options = this.visitCommandOptions(ctx.commandOptions());
            String appendSeparator = "";
            for (Map.Entry item : options.entrySet()) {
                if (!((String)item.getKey()).equalsIgnoreCase("append_separator")) {
                    throw new ParsingException(ParserUtils.source(ctx), "Invalid option for dissect: [{}]", item.getKey());
                }
                if (!(item.getValue() instanceof String)) {
                    throw new ParsingException(ParserUtils.source(ctx), "Invalid value for dissect append_separator: expected a string, but was [{}]", item.getValue());
                }
                appendSeparator = (String)item.getValue();
            }
            Source src = ParserUtils.source(ctx);
            try {
                DissectParser parser = new DissectParser(pattern, appendSeparator);
                Set referenceKeys = parser.referenceKeys();
                if (!referenceKeys.isEmpty()) {
                    throw new ParsingException(src, "Reference keys not supported in dissect patterns: [%{*{}}]", referenceKeys.iterator().next());
                }
                Dissect.Parser esqlDissectParser = new Dissect.Parser(pattern, appendSeparator, parser);
                List<Attribute> keys = esqlDissectParser.keyAttributes(src);
                return new Dissect(src, (LogicalPlan)((Object)p), this.expression((ParseTree)ctx.primaryExpression()), esqlDissectParser, keys);
            }
            catch (DissectException e) {
                throw new ParsingException(src, "Invalid pattern for dissect: [{}]", pattern);
            }
        };
    }

    @Override
    public PlanFactory visitMvExpandCommand(EsqlBaseParser.MvExpandCommandContext ctx) {
        UnresolvedAttribute field = this.visitQualifiedName(ctx.qualifiedName());
        Source src = ParserUtils.source(ctx);
        return child -> new MvExpand(src, (LogicalPlan)((Object)child), (NamedExpression)field, (Attribute)new UnresolvedAttribute(src, field.name()));
    }

    @Override
    public Map<String, Object> visitCommandOptions(EsqlBaseParser.CommandOptionsContext ctx) {
        if (ctx == null) {
            return Map.of();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (EsqlBaseParser.CommandOptionContext option : ctx.commandOption()) {
            result.put(this.visitIdentifier(option.identifier()), this.expression((ParseTree)option.constant()).fold());
        }
        return result;
    }

    @Override
    public LogicalPlan visitRowCommand(EsqlBaseParser.RowCommandContext ctx) {
        return new Row(ParserUtils.source(ctx), (List<Alias>)NamedExpressions.mergeOutputExpressions((List<? extends NamedExpression>)this.visitFields(ctx.fields()), List.of()));
    }

    @Override
    public LogicalPlan visitFromCommand(EsqlBaseParser.FromCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        TableIdentifier table = new TableIdentifier(source, null, this.visitIndexPattern((List)ctx.indexPattern()));
        LinkedHashMap<String, MetadataAttribute> metadataMap = new LinkedHashMap<String, MetadataAttribute>();
        if (ctx.metadata() != null) {
            EsqlBaseParser.Deprecated_metadataContext deprecatedContext = ctx.metadata().deprecated_metadata();
            EsqlBaseParser.MetadataOptionContext metadataOptionContext = null;
            if (deprecatedContext != null) {
                Location s = ParserUtils.source(deprecatedContext).source();
                HeaderWarning.addWarning((String)"Line {}:{}: Square brackets '[]' need to be removed in FROM METADATA declaration", (Object[])new Object[]{s.getLineNumber(), s.getColumnNumber()});
                metadataOptionContext = deprecatedContext.metadataOption();
            } else {
                metadataOptionContext = ctx.metadata().metadataOption();
            }
            for (TerminalNode c : metadataOptionContext.UNQUOTED_SOURCE()) {
                String id = c.getText();
                Source src = ParserUtils.source(c);
                if (!MetadataAttribute.isSupported((String)id)) {
                    throw new ParsingException(src, "unsupported metadata field [" + id + "]", new Object[0]);
                }
                Attribute a = (Attribute)metadataMap.put(id, MetadataAttribute.create((Source)src, (String)id));
                if (a == null) continue;
                throw new ParsingException(src, "metadata field [" + id + "] already declared [" + a.source().source() + "]", new Object[0]);
            }
        }
        return new UnresolvedRelation(source, table, false, List.of((Attribute[])metadataMap.values().toArray(Attribute[]::new)), IndexMode.STANDARD, null, "FROM");
    }

    @Override
    public PlanFactory visitStatsCommand(EsqlBaseParser.StatsCommandContext ctx) {
        Stats stats = this.stats(ParserUtils.source(ctx), ctx.grouping, ctx.stats);
        return input -> new Aggregate(ParserUtils.source(ctx), (LogicalPlan)((Object)input), Aggregate.AggregateType.STANDARD, stats.groupings, stats.aggregates);
    }

    private Stats stats(Source source, EsqlBaseParser.FieldsContext groupingsCtx, EsqlBaseParser.AggFieldsContext aggregatesCtx) {
        List<NamedExpression> groupings = this.visitGrouping(groupingsCtx);
        ArrayList<Attribute> aggregates = new ArrayList<Attribute>((Collection<Attribute>)this.visitAggFields(aggregatesCtx));
        if (aggregates.isEmpty() && groupings.isEmpty()) {
            throw new ParsingException(source, "At least one aggregation or grouping expression required in [{}]", source.text());
        }
        if (!groupings.isEmpty() && !aggregates.isEmpty()) {
            LinkedHashSet groupNames = new LinkedHashSet(Expressions.names(groupings));
            LinkedHashSet linkedHashSet = new LinkedHashSet(Expressions.names((Collection)Expressions.references(groupings)));
            for (NamedExpression namedExpression : aggregates) {
                Expression e = Alias.unwrap((Expression)namedExpression);
                if (e.resolved() || e instanceof UnresolvedFunction) continue;
                String name = e.sourceText();
                if (groupNames.contains(name)) {
                    this.fail(e, "grouping key [{}] already specified in the STATS BY clause", name);
                    continue;
                }
                if (!linkedHashSet.contains(name)) continue;
                this.fail(e, "Cannot specify grouping expression [{}] as an aggregate", name);
            }
        }
        for (Expression expression : groupings) {
            aggregates.add(Expressions.attribute((Expression)expression));
        }
        return new Stats(new ArrayList<NamedExpression>(groupings), aggregates);
    }

    private void fail(Expression exp, String message, Object ... args) {
        throw new VerificationException(Collections.singletonList(Failure.fail(exp, message, args)));
    }

    @Override
    public PlanFactory visitInlinestatsCommand(EsqlBaseParser.InlinestatsCommandContext ctx) {
        if (!EsqlPlugin.INLINESTATS_FEATURE_FLAG.isEnabled()) {
            throw new ParsingException(ParserUtils.source(ctx), "INLINESTATS command currently requires a snapshot build", new Object[0]);
        }
        Object aggFields = this.visitAggFields(ctx.stats);
        ArrayList<NamedExpression> aggregates = new ArrayList<NamedExpression>((Collection<NamedExpression>)aggFields);
        List<NamedExpression> groupings = this.visitGrouping(ctx.grouping);
        aggregates.addAll(groupings);
        return input -> new InlineStats(ParserUtils.source(ctx), (LogicalPlan)((Object)input), (List<Expression>)new ArrayList<Expression>(groupings), (List<? extends NamedExpression>)aggregates);
    }

    @Override
    public PlanFactory visitWhereCommand(EsqlBaseParser.WhereCommandContext ctx) {
        Expression expression = this.expression((ParseTree)ctx.booleanExpression());
        return input -> new Filter(ParserUtils.source(ctx), (LogicalPlan)((Object)input), expression);
    }

    @Override
    public PlanFactory visitLimitCommand(EsqlBaseParser.LimitCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        int limit = EsqlDataTypeConverter.stringToInt(ctx.INTEGER_LITERAL().getText());
        return input -> new Limit(source, (Expression)new Literal(source, (Object)limit, DataType.INTEGER), (LogicalPlan)((Object)input));
    }

    @Override
    public PlanFactory visitSortCommand(EsqlBaseParser.SortCommandContext ctx) {
        List<Order> orders = ParserUtils.visitList(this, ctx.orderExpression(), Order.class);
        Source source = ParserUtils.source(ctx);
        return input -> new OrderBy(source, (LogicalPlan)((Object)input), orders);
    }

    @Override
    public Explain visitExplainCommand(EsqlBaseParser.ExplainCommandContext ctx) {
        return new Explain(ParserUtils.source(ctx), this.plan((ParseTree)ctx.subqueryExpression().query()));
    }

    @Override
    public PlanFactory visitDropCommand(EsqlBaseParser.DropCommandContext ctx) {
        List<NamedExpression> removals = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedStar) {
                Source src = ne.source();
                throw new ParsingException(src, "Removing all fields is not allowed [{}]", src.text());
            }
        });
        return child -> new Drop(ParserUtils.source(ctx), (LogicalPlan)((Object)child), removals);
    }

    @Override
    public PlanFactory visitRenameCommand(EsqlBaseParser.RenameCommandContext ctx) {
        List<Alias> renamings = ctx.renameClause().stream().map(this::visitRenameClause).toList();
        return child -> new Rename(ParserUtils.source(ctx), (LogicalPlan)((Object)child), renamings);
    }

    @Override
    public PlanFactory visitKeepCommand(EsqlBaseParser.KeepCommandContext ctx) {
        Holder hasSeenStar = new Holder((Object)false);
        List<NamedExpression> projections = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedStar) {
                if (((Boolean)hasSeenStar.get()).booleanValue()) {
                    Source src = ne.source();
                    throw new ParsingException(src, "Cannot specify [*] more than once", src.text());
                }
                hasSeenStar.set((Object)Boolean.TRUE);
            }
        });
        return child -> new Keep(ParserUtils.source(ctx), (LogicalPlan)((Object)child), (List<? extends NamedExpression>)projections);
    }

    @Override
    public LogicalPlan visitShowInfo(EsqlBaseParser.ShowInfoContext ctx) {
        return new ShowInfo(ParserUtils.source(ctx));
    }

    @Override
    public PlanFactory visitEnrichCommand(EsqlBaseParser.EnrichCommandContext ctx) {
        return p -> {
            String patternString;
            EmptyAttribute matchField;
            Source source = ParserUtils.source(ctx);
            Tuple<Enrich.Mode, String> tuple = LogicalPlanBuilder.parsePolicyName(ctx.policyName);
            Enrich.Mode mode = (Enrich.Mode)((Object)((Object)tuple.v1()));
            String policyNameString = (String)tuple.v2();
            Object object = matchField = ctx.ON() != null ? this.visitQualifiedNamePattern(ctx.matchField) : new EmptyAttribute(source);
            if (matchField instanceof UnresolvedNamePattern) {
                UnresolvedNamePattern up = (UnresolvedNamePattern)matchField;
                v1 = up.pattern();
            } else {
                v1 = patternString = matchField instanceof UnresolvedStar ? "*" : null;
            }
            if (patternString != null) {
                throw new ParsingException(source, "Using wildcards [*] in ENRICH WITH projections is not allowed [{}]", patternString);
            }
            List<NamedExpression> keepClauses = ParserUtils.visitList(this, ctx.enrichWithClause(), NamedExpression.class);
            return new Enrich(source, (LogicalPlan)((Object)p), mode, (Expression)new Literal(ParserUtils.source(ctx.policyName), (Object)policyNameString, DataType.KEYWORD), (NamedExpression)matchField, null, Map.of(), (List<NamedExpression>)(keepClauses.isEmpty() ? List.of() : keepClauses));
        };
    }

    private static Tuple<Enrich.Mode, String> parsePolicyName(Token policyToken) {
        String stringValue = policyToken.getText();
        int index = stringValue.indexOf(":");
        Enrich.Mode mode = null;
        if (index >= 0) {
            String modeValue = stringValue.substring(0, index);
            if (modeValue.startsWith("_")) {
                mode = Enrich.Mode.from(modeValue.substring(1));
            }
            if (mode == null) {
                throw new ParsingException(ParserUtils.source(policyToken), "Unrecognized value [{}], ENRICH policy qualifier needs to be one of {}", modeValue, Arrays.stream(Enrich.Mode.values()).map(s -> "_" + s).toList());
            }
        } else {
            mode = Enrich.Mode.ANY;
        }
        String policyName = index < 0 ? stringValue : stringValue.substring(index + 1);
        return new Tuple((Object)mode, (Object)policyName);
    }

    @Override
    public LogicalPlan visitMetricsCommand(EsqlBaseParser.MetricsCommandContext ctx) {
        if (!Build.current().isSnapshot()) {
            throw new IllegalArgumentException("METRICS command currently requires a snapshot build");
        }
        Source source = ParserUtils.source(ctx);
        TableIdentifier table = new TableIdentifier(source, null, this.visitIndexPattern((List)ctx.indexPattern()));
        if (ctx.aggregates == null && ctx.grouping == null) {
            return new UnresolvedRelation(source, table, false, List.of(), IndexMode.STANDARD, null, "METRICS");
        }
        Stats stats = this.stats(source, ctx.grouping, ctx.aggregates);
        UnresolvedRelation relation = new UnresolvedRelation(source, table, false, List.of(new MetadataAttribute(source, "_tsid", DataType.KEYWORD, false)), IndexMode.TIME_SERIES, null, "FROM TS");
        return new Aggregate(source, relation, Aggregate.AggregateType.METRICS, stats.groupings, stats.aggregates);
    }

    @Override
    public PlanFactory visitLookupCommand(EsqlBaseParser.LookupCommandContext ctx) {
        if (!Build.current().isSnapshot()) {
            throw new ParsingException(ParserUtils.source(ctx), "LOOKUP is in preview and only available in SNAPSHOT build", new Object[0]);
        }
        Source source = ParserUtils.source(ctx);
        List<NamedExpression> matchFields = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedNamePattern || ne instanceof UnresolvedStar) {
                Source src = ne.source();
                throw new ParsingException(src, "Using wildcards [*] in LOOKUP ON is not allowed yet [{}]", src.text());
            }
            if (!(ne instanceof UnresolvedAttribute)) {
                throw new IllegalStateException("visitQualifiedNamePatterns can only return UnresolvedNamePattern, UnresolvedStar or UnresolvedAttribute");
            }
        });
        Literal tableName = new Literal(source, (Object)this.visitIndexPattern((List)List.of(ctx.indexPattern())), DataType.KEYWORD);
        return p -> new Lookup(source, (LogicalPlan)((Object)p), (Expression)tableName, (List<Attribute>)matchFields, null);
    }

    static interface PlanFactory
    extends Function<LogicalPlan, LogicalPlan> {
    }

    private record Stats(List<Expression> groupings, List<? extends NamedExpression> aggregates) {
    }
}

