/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistance;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushDownUtils;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;

public class PushTopNToSource
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<TopNExec, LocalPhysicalOptimizerContext> {
    private static final Pushable NO_OP = new NoOpPushable();

    @Override
    protected PhysicalPlan rule(TopNExec topNExec, LocalPhysicalOptimizerContext ctx) {
        Pushable pushable = PushTopNToSource.evaluatePushable(topNExec, x -> LucenePushDownUtils.hasIdenticalDelegate(x, ctx.searchStats()));
        return pushable.rewrite(topNExec);
    }

    private static Pushable evaluatePushable(TopNExec topNExec, Predicate<FieldAttribute> hasIdenticalDelegate) {
        EsQueryExec queryExec;
        EvalExec evalExec;
        PhysicalPlan physicalPlan;
        EsQueryExec queryExec2;
        PhysicalPlan child = topNExec.child();
        if (child instanceof EsQueryExec && (queryExec2 = (EsQueryExec)child).canPushSorts() && PushTopNToSource.canPushDownOrders(topNExec.order(), hasIdenticalDelegate)) {
            return new PushableQueryExec(queryExec2);
        }
        if (child instanceof EvalExec && (physicalPlan = (evalExec = (EvalExec)child).child()) instanceof EsQueryExec && (queryExec = (EsQueryExec)physicalPlan).canPushSorts()) {
            List<Order> orders = topNExec.order();
            List<Alias> fields = evalExec.fields();
            LinkedHashMap distances = new LinkedHashMap();
            AttributeMap.Builder aliasReplacedByBuilder = AttributeMap.builder();
            fields.forEach(alias -> {
                StDistance distance;
                Expression patt6967$temp = alias.child();
                if (patt6967$temp instanceof StDistance && (distance = (StDistance)patt6967$temp).crsType() == BinarySpatialFunction.SpatialCrsType.GEO) {
                    distances.put(alias.id(), distance);
                } else {
                    Expression patt7165$temp = alias.child();
                    if (patt7165$temp instanceof Attribute) {
                        Attribute attr = (Attribute)patt7165$temp;
                        aliasReplacedByBuilder.put(alias.toAttribute(), (Object)attr.toAttribute());
                    }
                }
            });
            AttributeMap aliasReplacedBy = aliasReplacedByBuilder.build();
            ArrayList<EsQueryExec.Sort> pushableSorts = new ArrayList<EsQueryExec.Sort>();
            for (Order order : orders) {
                FieldAttribute fieldAttribute;
                if (LucenePushDownUtils.isPushableFieldAttribute(order.child(), hasIdenticalDelegate)) {
                    pushableSorts.add(new EsQueryExec.FieldSort(((FieldAttribute)order.child()).exactAttribute(), order.direction(), order.nullsPosition()));
                    continue;
                }
                Expression expression = order.child();
                if (!(expression instanceof ReferenceAttribute)) break;
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)expression;
                Attribute resolvedAttribute = (Attribute)aliasReplacedBy.resolve((Object)referenceAttribute, (Object)referenceAttribute);
                if (distances.containsKey(resolvedAttribute.id())) {
                    StDistance distance = (StDistance)distances.get(resolvedAttribute.id());
                    StDistance d = (StDistance)distance.transformDown(ReferenceAttribute.class, r -> (Expression)aliasReplacedBy.resolve(r, r));
                    PushableGeoDistance pushableGeoDistance = PushableGeoDistance.from(d, order);
                    if (pushableGeoDistance == null) break;
                    pushableSorts.add(pushableGeoDistance.sort());
                    continue;
                }
                Object object = aliasReplacedBy.resolve((Object)referenceAttribute, (Object)referenceAttribute);
                if (!(object instanceof FieldAttribute) || !LucenePushDownUtils.isPushableFieldAttribute((Expression)(fieldAttribute = (FieldAttribute)object), hasIdenticalDelegate)) break;
                pushableSorts.add(new EsQueryExec.FieldSort(fieldAttribute.exactAttribute(), order.direction(), order.nullsPosition()));
            }
            if (pushableSorts.size() > 0 && pushableSorts.size() == orders.size()) {
                return new PushableCompoundExec(evalExec, queryExec, pushableSorts);
            }
        }
        return NO_OP;
    }

    private static boolean canPushDownOrders(List<Order> orders, Predicate<FieldAttribute> hasIdenticalDelegate) {
        return orders.stream().allMatch(o -> LucenePushDownUtils.isPushableFieldAttribute(o.child(), hasIdenticalDelegate));
    }

    private static List<EsQueryExec.Sort> buildFieldSorts(List<Order> orders) {
        ArrayList<EsQueryExec.Sort> sorts = new ArrayList<EsQueryExec.Sort>(orders.size());
        for (Order o : orders) {
            sorts.add(new EsQueryExec.FieldSort(((FieldAttribute)o.child()).exactAttribute(), o.direction(), o.nullsPosition()));
        }
        return sorts;
    }

    static interface Pushable {
        public PhysicalPlan rewrite(TopNExec var1);
    }

    record PushableQueryExec(EsQueryExec queryExec) implements Pushable
    {
        @Override
        public PhysicalPlan rewrite(TopNExec topNExec) {
            List<EsQueryExec.Sort> sorts = PushTopNToSource.buildFieldSorts(topNExec.order());
            Expression limit = topNExec.limit();
            return this.queryExec.withSorts(sorts).withLimit(limit);
        }
    }

    record PushableGeoDistance(FieldAttribute fieldAttribute, Order order, Point point) {
        private EsQueryExec.Sort sort() {
            return new EsQueryExec.GeoDistanceSort(this.fieldAttribute.exactAttribute(), this.order.direction(), this.point.getLat(), this.point.getLon());
        }

        private static PushableGeoDistance from(StDistance distance, Order order) {
            Expression expression = distance.left();
            if (expression instanceof Attribute) {
                Attribute attr = (Attribute)expression;
                if (distance.right().foldable()) {
                    return PushableGeoDistance.from(attr, distance.right(), order);
                }
            }
            if ((expression = distance.right()) instanceof Attribute) {
                Attribute attr = (Attribute)expression;
                if (distance.left().foldable()) {
                    return PushableGeoDistance.from(attr, distance.left(), order);
                }
            }
            return null;
        }

        private static PushableGeoDistance from(Attribute attr, Expression foldable, Order order) {
            if (attr instanceof FieldAttribute) {
                FieldAttribute fieldAttribute = (FieldAttribute)attr;
                Geometry geometry = SpatialRelatesUtils.makeGeometryFromLiteral(foldable);
                if (geometry instanceof Point) {
                    Point point = (Point)geometry;
                    return new PushableGeoDistance(fieldAttribute, order, point);
                }
            }
            return null;
        }
    }

    record PushableCompoundExec(EvalExec evalExec, EsQueryExec queryExec, List<EsQueryExec.Sort> pushableSorts) implements Pushable
    {
        @Override
        public PhysicalPlan rewrite(TopNExec topNExec) {
            return this.evalExec.replaceChild(this.queryExec.withSorts(this.pushableSorts).withLimit(topNExec.limit()));
        }
    }

    record NoOpPushable() implements Pushable
    {
        @Override
        public PhysicalPlan rewrite(TopNExec topNExec) {
            return topNExec;
        }
    }
}

