/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.core.expression.predicate.Range;
import org.elasticsearch.xpack.esql.core.expression.predicate.fulltext.MatchQueryPredicate;
import org.elasticsearch.xpack.esql.core.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.core.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.esql.core.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardLike;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.Queries;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Match;
import org.elasticsearch.xpack.esql.expression.function.fulltext.QueryString;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatch;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.InsensitiveBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushDownUtils;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class PushFiltersToSource
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<FilterExec, LocalPhysicalOptimizerContext> {
    @Override
    protected PhysicalPlan rule(FilterExec filterExec, LocalPhysicalOptimizerContext ctx) {
        PhysicalPlan plan = filterExec;
        PhysicalPlan physicalPlan = filterExec.child();
        if (physicalPlan instanceof EsQueryExec) {
            EsQueryExec queryExec = (EsQueryExec)physicalPlan;
            plan = PushFiltersToSource.planFilterExec(filterExec, queryExec, ctx);
        } else {
            EvalExec evalExec;
            physicalPlan = filterExec.child();
            if (physicalPlan instanceof EvalExec && (physicalPlan = (evalExec = (EvalExec)physicalPlan).child()) instanceof EsQueryExec) {
                EsQueryExec queryExec = (EsQueryExec)physicalPlan;
                plan = PushFiltersToSource.planFilterExec(filterExec, evalExec, queryExec, ctx);
            }
        }
        return plan;
    }

    private static PhysicalPlan planFilterExec(FilterExec filterExec, EsQueryExec queryExec, LocalPhysicalOptimizerContext ctx) {
        ArrayList<Expression> pushable = new ArrayList<Expression>();
        ArrayList<Expression> nonPushable = new ArrayList<Expression>();
        for (Expression exp : Predicates.splitAnd((Expression)filterExec.condition())) {
            (PushFiltersToSource.canPushToSource(exp, x -> LucenePushDownUtils.hasIdenticalDelegate(x, ctx.searchStats())) ? pushable : nonPushable).add(exp);
        }
        return PushFiltersToSource.rewrite(filterExec, queryExec, pushable, nonPushable, List.of());
    }

    private static PhysicalPlan planFilterExec(FilterExec filterExec, EvalExec evalExec, EsQueryExec queryExec, LocalPhysicalOptimizerContext ctx) {
        AttributeMap<Attribute> aliasReplacedBy = PushFiltersToSource.getAliasReplacedBy(evalExec);
        ArrayList<Expression> pushable = new ArrayList<Expression>();
        ArrayList<Expression> nonPushable = new ArrayList<Expression>();
        for (Expression exp : Predicates.splitAnd((Expression)filterExec.condition())) {
            Expression resExp = (Expression)exp.transformUp(ReferenceAttribute.class, r -> (Expression)aliasReplacedBy.resolve(r, r));
            (PushFiltersToSource.canPushToSource(resExp, x -> LucenePushDownUtils.hasIdenticalDelegate(x, ctx.searchStats())) ? pushable : nonPushable).add(exp);
        }
        pushable.replaceAll(e -> (Expression)e.transformDown(ReferenceAttribute.class, r -> (Expression)aliasReplacedBy.resolve(r, r)));
        return PushFiltersToSource.rewrite(filterExec, queryExec, pushable, nonPushable, evalExec.fields());
    }

    static AttributeMap<Attribute> getAliasReplacedBy(EvalExec evalExec) {
        AttributeMap.Builder aliasReplacedByBuilder = AttributeMap.builder();
        evalExec.fields().forEach(alias -> {
            Expression patt6610$temp = alias.child();
            if (patt6610$temp instanceof Attribute) {
                Attribute attr = (Attribute)patt6610$temp;
                aliasReplacedByBuilder.put(alias.toAttribute(), (Object)attr);
            }
        });
        return aliasReplacedByBuilder.build();
    }

    private static PhysicalPlan rewrite(FilterExec filterExec, EsQueryExec queryExec, List<Expression> pushable, List<Expression> nonPushable, List<Alias> evalFields) {
        List<Expression> newPushable = PushFiltersToSource.combineEligiblePushableToRange(pushable);
        if (newPushable.size() > 0) {
            PhysicalPlan plan;
            Query queryDSL = PlannerUtils.TRANSLATOR_HANDLER.asQuery(Predicates.combineAnd(newPushable));
            QueryBuilder planQuery = queryDSL.asBuilder();
            QueryBuilder query = Queries.combine((Queries.Clause)Queries.Clause.FILTER, Arrays.asList(queryExec.query(), planQuery));
            queryExec = new EsQueryExec(queryExec.source(), queryExec.index(), queryExec.indexMode(), queryExec.output(), query, queryExec.limit(), queryExec.sorts(), queryExec.estimatedRowSize());
            PhysicalPlan physicalPlan = plan = evalFields.isEmpty() ? queryExec : new EvalExec(filterExec.source(), queryExec, evalFields);
            if (nonPushable.size() > 0) {
                return new FilterExec(filterExec.source(), plan, Predicates.combineAnd(nonPushable));
            }
            return plan;
        }
        return filterExec;
    }

    private static List<Expression> combineEligiblePushableToRange(List<Expression> pushable) {
        ArrayList bcs = new ArrayList();
        ArrayList<Range> ranges = new ArrayList<Range>();
        ArrayList others = new ArrayList();
        boolean changed = false;
        pushable.forEach(e -> {
            if (e instanceof GreaterThan || e instanceof GreaterThanOrEqual || e instanceof LessThan || e instanceof LessThanOrEqual) {
                if (((EsqlBinaryComparison)e).right().foldable()) {
                    bcs.add((EsqlBinaryComparison)e);
                } else {
                    others.add(e);
                }
            } else {
                others.add(e);
            }
        });
        int step = 1;
        for (int i = 0; i < bcs.size() - 1; i += step) {
            BinaryComparison main = (BinaryComparison)bcs.get(i);
            for (int j = i + 1; j < bcs.size(); ++j) {
                BinaryComparison other = (BinaryComparison)bcs.get(j);
                if (!main.left().semanticEquals(other.left())) continue;
                if ((main instanceof GreaterThan || main instanceof GreaterThanOrEqual) && (other instanceof LessThan || other instanceof LessThanOrEqual)) {
                    bcs.remove(j);
                    bcs.remove(i);
                    ranges.add(new Range(main.source(), main.left(), main.right(), main instanceof GreaterThanOrEqual, other.right(), other instanceof LessThanOrEqual, main.zoneId()));
                    changed = true;
                    step = 0;
                    break;
                }
                if (!(other instanceof GreaterThan) && !(other instanceof GreaterThanOrEqual) || !(main instanceof LessThan) && !(main instanceof LessThanOrEqual)) continue;
                bcs.remove(j);
                bcs.remove(i);
                ranges.add(new Range(main.source(), main.left(), other.right(), other instanceof GreaterThanOrEqual, main.right(), main instanceof LessThanOrEqual, main.zoneId()));
                changed = true;
                step = 0;
                break;
            }
            step = 1;
        }
        return changed ? CollectionUtils.combine((Collection[])new Collection[]{others, bcs, ranges}) : pushable;
    }

    public static boolean canPushToSource(Expression exp, Predicate<FieldAttribute> hasIdenticalDelegate) {
        if (exp instanceof BinaryComparison) {
            BinaryComparison bc = (BinaryComparison)exp;
            return PushFiltersToSource.isAttributePushable(bc.left(), (Expression)bc, hasIdenticalDelegate) && bc.right().foldable();
        }
        if (exp instanceof InsensitiveBinaryComparison) {
            InsensitiveBinaryComparison bc = (InsensitiveBinaryComparison)exp;
            return PushFiltersToSource.isAttributePushable(bc.left(), (Expression)bc, hasIdenticalDelegate) && bc.right().foldable();
        }
        if (exp instanceof BinaryLogic) {
            BinaryLogic bl = (BinaryLogic)exp;
            return PushFiltersToSource.canPushToSource(bl.left(), hasIdenticalDelegate) && PushFiltersToSource.canPushToSource(bl.right(), hasIdenticalDelegate);
        }
        if (exp instanceof In) {
            In in = (In)exp;
            return PushFiltersToSource.isAttributePushable(in.value(), null, hasIdenticalDelegate) && Expressions.foldable(in.list());
        }
        if (exp instanceof Not) {
            Not not = (Not)exp;
            return PushFiltersToSource.canPushToSource(not.field(), hasIdenticalDelegate);
        }
        if (exp instanceof UnaryScalarFunction) {
            UnaryScalarFunction usf = (UnaryScalarFunction)exp;
            if (usf instanceof RegexMatch || usf instanceof IsNull || usf instanceof IsNotNull) {
                FieldAttribute fa;
                Expression expression;
                if ((usf instanceof IsNull || usf instanceof IsNotNull) && (expression = usf.field()) instanceof FieldAttribute && (fa = (FieldAttribute)expression).dataType().equals((Object)DataType.TEXT)) {
                    return true;
                }
                return PushFiltersToSource.isAttributePushable(usf.field(), (Expression)usf, hasIdenticalDelegate);
            }
        } else {
            if (exp instanceof CIDRMatch) {
                CIDRMatch cidrMatch = (CIDRMatch)exp;
                return PushFiltersToSource.isAttributePushable(cidrMatch.ipField(), (Expression)cidrMatch, hasIdenticalDelegate) && Expressions.foldable(cidrMatch.matches());
            }
            if (exp instanceof SpatialRelatesFunction) {
                SpatialRelatesFunction spatial = (SpatialRelatesFunction)exp;
                return PushFiltersToSource.canPushSpatialFunctionToSource(spatial);
            }
            if (exp instanceof MatchQueryPredicate) {
                MatchQueryPredicate mqp = (MatchQueryPredicate)exp;
                return mqp.field() instanceof FieldAttribute && DataType.isString((DataType)mqp.field().dataType());
            }
            if (exp instanceof StringQueryPredicate) {
                return true;
            }
            if (exp instanceof QueryString) {
                return true;
            }
            if (exp instanceof Match) {
                Match mf = (Match)exp;
                return mf.field() instanceof FieldAttribute && DataType.isString((DataType)mf.field().dataType());
            }
        }
        return false;
    }

    public static boolean canPushSpatialFunctionToSource(BinarySpatialFunction s) {
        return PushFiltersToSource.isPushableSpatialAttribute(s.left()) && s.right().foldable() || PushFiltersToSource.isPushableSpatialAttribute(s.right()) && s.left().foldable();
    }

    private static boolean isPushableSpatialAttribute(Expression exp) {
        FieldAttribute fa;
        return exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).getExactInfo().hasExact() && LucenePushDownUtils.isAggregatable(fa) && DataType.isSpatial((DataType)fa.dataType());
    }

    private static boolean isAttributePushable(Expression expression, Expression operation, Predicate<FieldAttribute> hasIdenticalDelegate) {
        MetadataAttribute ma;
        if (LucenePushDownUtils.isPushableFieldAttribute(expression, hasIdenticalDelegate)) {
            return true;
        }
        if (expression instanceof MetadataAttribute && (ma = (MetadataAttribute)expression).searchable()) {
            return operation == null || operation instanceof Equals || operation instanceof NotEquals || operation instanceof WildcardLike;
        }
        return false;
    }
}

