/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.WellKnownBinary;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersects;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistance;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushFiltersToSource;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class EnableSpatialDistancePushdown
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<FilterExec, LocalPhysicalOptimizerContext> {
    @Override
    protected PhysicalPlan rule(FilterExec filterExec, LocalPhysicalOptimizerContext ctx) {
        PhysicalPlan plan = filterExec;
        PhysicalPlan physicalPlan = filterExec.child();
        if (physicalPlan instanceof EsQueryExec) {
            EsQueryExec esQueryExec = (EsQueryExec)physicalPlan;
            plan = this.rewrite(filterExec, esQueryExec);
        } else {
            EvalExec evalExec;
            physicalPlan = filterExec.child();
            if (physicalPlan instanceof EvalExec && (physicalPlan = (evalExec = (EvalExec)physicalPlan).child()) instanceof EsQueryExec) {
                EsQueryExec esQueryExec = (EsQueryExec)physicalPlan;
                plan = this.rewriteBySplittingFilter(filterExec, evalExec, esQueryExec);
            }
        }
        return plan;
    }

    private FilterExec rewrite(FilterExec filterExec, EsQueryExec esQueryExec) {
        Expression rewritten = (Expression)filterExec.condition().transformDown(EsqlBinaryComparison.class, comparison -> {
            Expression patt5032$temp;
            ComparisonType comparisonType = ComparisonType.from(comparison.getFunctionType());
            Expression patt4831$temp = comparison.left();
            if (patt4831$temp instanceof StDistance) {
                StDistance dist = (StDistance)patt4831$temp;
                if (comparison.right().foldable()) {
                    return this.rewriteComparison((EsqlBinaryComparison)comparison, dist, comparison.right(), comparisonType);
                }
            }
            if ((patt5032$temp = comparison.right()) instanceof StDistance) {
                StDistance dist = (StDistance)patt5032$temp;
                if (comparison.left().foldable()) {
                    return this.rewriteComparison((EsqlBinaryComparison)comparison, dist, comparison.left(), ComparisonType.invert(comparisonType));
                }
            }
            return comparison;
        });
        if (!rewritten.equals((Object)filterExec.condition()) && PushFiltersToSource.canPushToSource(rewritten, x -> false)) {
            return new FilterExec(filterExec.source(), esQueryExec, rewritten);
        }
        return filterExec;
    }

    private PhysicalPlan rewriteBySplittingFilter(FilterExec filterExec, EvalExec evalExec, EsQueryExec esQueryExec) {
        Map<NameId, StDistance> distances = this.getPushableDistances(evalExec.fields());
        if (distances.isEmpty()) {
            return filterExec;
        }
        AttributeMap<Attribute> aliasReplacedBy = PushFiltersToSource.getAliasReplacedBy(evalExec);
        ArrayList<Expression> pushable = new ArrayList<Expression>();
        ArrayList<Expression> nonPushable = new ArrayList<Expression>();
        for (Expression exp : Predicates.splitAnd((Expression)filterExec.condition())) {
            Expression resExp = (Expression)exp.transformUp(ReferenceAttribute.class, r -> (Expression)aliasReplacedBy.resolve(r, r));
            Expression rewritten = this.rewriteDistanceFilters(resExp, distances);
            if (!rewritten.equals((Object)resExp) && PushFiltersToSource.canPushToSource(rewritten, x -> false)) {
                pushable.add(rewritten);
                continue;
            }
            nonPushable.add(exp);
        }
        if (pushable.isEmpty()) {
            return filterExec;
        }
        FilterExec distanceFilter = new FilterExec(filterExec.source(), esQueryExec, Predicates.combineAnd(pushable));
        EvalExec newEval = new EvalExec(evalExec.source(), distanceFilter, evalExec.fields());
        if (nonPushable.isEmpty()) {
            return newEval;
        }
        return new FilterExec(filterExec.source(), newEval, Predicates.combineAnd(nonPushable));
    }

    private Map<NameId, StDistance> getPushableDistances(List<Alias> aliases) {
        LinkedHashMap<NameId, StDistance> distances = new LinkedHashMap<NameId, StDistance>();
        aliases.forEach(alias -> {
            StDistance distance;
            Expression patt8842$temp = alias.child();
            if (patt8842$temp instanceof StDistance && PushFiltersToSource.canPushSpatialFunctionToSource(distance = (StDistance)patt8842$temp)) {
                distances.put(alias.id(), distance);
            } else {
                ReferenceAttribute ref;
                Expression patt9010$temp = alias.child();
                if (patt9010$temp instanceof ReferenceAttribute && distances.containsKey((ref = (ReferenceAttribute)patt9010$temp).id())) {
                    StDistance distance2 = (StDistance)distances.get(ref.id());
                    distances.put(alias.id(), distance2);
                }
            }
        });
        return distances;
    }

    private Expression rewriteDistanceFilters(Expression expr, Map<NameId, StDistance> distances) {
        return (Expression)expr.transformDown(EsqlBinaryComparison.class, comparison -> {
            ReferenceAttribute r;
            StDistance dist;
            ReferenceAttribute r2;
            ComparisonType comparisonType = ComparisonType.from(comparison.getFunctionType());
            Expression patt9564$temp = comparison.left();
            if (patt9564$temp instanceof ReferenceAttribute && distances.containsKey((r2 = (ReferenceAttribute)patt9564$temp).id()) && comparison.right().foldable()) {
                dist = (StDistance)distances.get(r2.id());
                return this.rewriteComparison((EsqlBinaryComparison)comparison, dist, comparison.right(), comparisonType);
            }
            Expression patt9860$temp = comparison.right();
            if (patt9860$temp instanceof ReferenceAttribute && distances.containsKey((r = (ReferenceAttribute)patt9860$temp).id()) && comparison.left().foldable()) {
                dist = (StDistance)distances.get(r.id());
                return this.rewriteComparison((EsqlBinaryComparison)comparison, dist, comparison.left(), ComparisonType.invert(comparisonType));
            }
            return comparison;
        });
    }

    private Expression rewriteComparison(EsqlBinaryComparison comparison, StDistance dist, Expression literal, ComparisonType comparisonType) {
        Object value = literal.fold();
        if (value instanceof Number) {
            Number number = (Number)value;
            if (dist.right().foldable()) {
                return this.rewriteDistanceFilter(comparison, dist.left(), dist.right(), number, comparisonType);
            }
            if (dist.left().foldable()) {
                return this.rewriteDistanceFilter(comparison, dist.right(), dist.left(), number, comparisonType);
            }
        }
        return comparison;
    }

    private Expression rewriteDistanceFilter(EsqlBinaryComparison comparison, Expression spatialExp, Expression literalExp, Number number, ComparisonType comparisonType) {
        DataType shapeDataType = this.getShapeDataType(spatialExp);
        Geometry geometry = SpatialRelatesUtils.makeGeometryFromLiteral(literalExp);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            double distance = number.doubleValue();
            Source source = comparison.source();
            if (comparisonType.lt) {
                distance = comparisonType.eq ? distance : Math.nextDown(distance);
                return new SpatialIntersects(source, spatialExp, (Expression)this.makeCircleLiteral(point, distance, literalExp, shapeDataType));
            }
            if (comparisonType.gt) {
                distance = comparisonType.eq ? distance : Math.nextUp(distance);
                return new SpatialDisjoint(source, spatialExp, (Expression)this.makeCircleLiteral(point, distance, literalExp, shapeDataType));
            }
            if (comparisonType.eq) {
                return new And(source, (Expression)new SpatialIntersects(source, spatialExp, (Expression)this.makeCircleLiteral(point, distance, literalExp, shapeDataType)), (Expression)new SpatialDisjoint(source, spatialExp, (Expression)this.makeCircleLiteral(point, Math.nextDown(distance), literalExp, shapeDataType)));
            }
        }
        return comparison;
    }

    private Literal makeCircleLiteral(Point point, double distance, Expression literalExpression, DataType shapeDataType) {
        Circle circle = new Circle(point.getX(), point.getY(), distance);
        byte[] wkb = WellKnownBinary.toWKB((Geometry)circle, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        return new Literal(literalExpression.source(), (Object)new BytesRef(wkb), shapeDataType);
    }

    private DataType getShapeDataType(Expression expression) {
        return switch (expression.dataType()) {
            case DataType.GEO_POINT, DataType.GEO_SHAPE -> DataType.GEO_SHAPE;
            case DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE -> DataType.CARTESIAN_SHAPE;
            default -> throw new IllegalArgumentException("Unsupported spatial data type: " + expression.dataType());
        };
    }

    static enum ComparisonType {
        LTE(true, false, true),
        LT(true, false, false),
        GTE(false, true, true),
        GT(false, true, false),
        EQ(false, false, true);

        private final boolean lt;
        private final boolean gt;
        private final boolean eq;

        private ComparisonType(boolean lt, boolean gt, boolean eq) {
            this.lt = lt;
            this.gt = gt;
            this.eq = eq;
        }

        static ComparisonType from(EsqlBinaryComparison.BinaryComparisonOperation op) {
            return switch (op) {
                case EsqlBinaryComparison.BinaryComparisonOperation.LT -> LT;
                case EsqlBinaryComparison.BinaryComparisonOperation.LTE -> LTE;
                case EsqlBinaryComparison.BinaryComparisonOperation.GT -> GT;
                case EsqlBinaryComparison.BinaryComparisonOperation.GTE -> GTE;
                default -> EQ;
            };
        }

        static ComparisonType invert(ComparisonType comparisonType) {
            return switch (comparisonType) {
                case LT -> GT;
                case LTE -> GTE;
                case GT -> LT;
                case GTE -> LTE;
                default -> EQ;
            };
        }
    }
}

