/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.TemporaryNameUtils;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;

public final class ReplaceStatsAggExpressionWithEval
extends OptimizerRules.OptimizerRule<Aggregate> {
    public ReplaceStatsAggExpressionWithEval() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    protected LogicalPlan rule(Aggregate aggregate) {
        AttributeMap aliases = new AttributeMap();
        aggregate.forEachExpressionUp(Alias.class, a -> aliases.put(a.toAttribute(), (Object)a.child()));
        List<? extends NamedExpression> aggs = aggregate.aggregates();
        LinkedHashMap rootAggs = Maps.newLinkedHashMapWithExpectedSize((int)aggs.size());
        ArrayList<Alias> newEvals = new ArrayList<Alias>();
        ArrayList<Object> newProjections = new ArrayList<Object>();
        ArrayList<Object> newAggs = new ArrayList<Object>();
        Holder changed = new Holder((Object)false);
        int[] counter = new int[]{0};
        for (NamedExpression namedExpression : aggs) {
            if (namedExpression instanceof Alias) {
                Alias as = (Alias)namedExpression;
                Expression child = as.child();
                if (child instanceof AggregateFunction) {
                    AggregateFunction af2 = (AggregateFunction)child;
                    AggregateFunction canonical = (AggregateFunction)af2.canonical().transformUp(e -> (Expression)aliases.resolve(e, e));
                    Alias found = (Alias)rootAggs.get((Object)canonical);
                    if (found == null) {
                        rootAggs.put(canonical, as);
                        newAggs.add(as);
                        newProjections.add(as.toAttribute());
                        continue;
                    }
                    changed.set((Object)true);
                    newProjections.add(as.replaceChild((Expression)found.toAttribute()));
                    continue;
                }
                changed.set((Object)true);
                Expression aggExpression = (Expression)child.transformUp(AggregateFunction.class, af -> {
                    AggregateFunction canonical = (AggregateFunction)af.canonical();
                    Alias alias = (Alias)rootAggs.get((Object)canonical);
                    if (alias == null) {
                        int n = counter[0];
                        counter[0] = n + 1;
                        alias = new Alias(af.source(), ReplaceStatsAggExpressionWithEval.syntheticName((Expression)canonical, child, n), (Expression)canonical, null, true);
                        rootAggs.put(canonical, alias);
                        newAggs.add(alias);
                    }
                    return alias.toAttribute();
                });
                Alias alias = as.replaceChild(aggExpression);
                newEvals.add(alias);
                newProjections.add(alias.toAttribute());
                continue;
            }
            newAggs.add(namedExpression);
            newProjections.add(namedExpression.toAttribute());
        }
        Object plan = aggregate;
        if (((Boolean)changed.get()).booleanValue()) {
            Source source = aggregate.source();
            plan = aggregate.with(aggregate.child(), (List)aggregate.groupings(), newAggs);
            if (newEvals.size() > 0) {
                plan = new Eval(source, (LogicalPlan)((Object)plan), newEvals);
            }
            plan = new Project(source, (LogicalPlan)((Object)plan), newProjections);
        }
        return plan;
    }

    static String syntheticName(Expression expression, Expression af, int counter) {
        return TemporaryNameUtils.temporaryName(expression, af, counter);
    }
}

