/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.esql.analysis.AnalyzerRules;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Stats;

public final class RemoveStatsOverride
extends AnalyzerRules.AnalyzerRule<LogicalPlan> {
    @Override
    protected boolean skipResolved() {
        return false;
    }

    @Override
    protected LogicalPlan rule(LogicalPlan p) {
        if (!p.resolved()) {
            return p;
        }
        if (p instanceof Stats) {
            Stats stats = (Stats)((Object)p);
            return (LogicalPlan)((Object)stats.with(stats.child(), RemoveStatsOverride.removeDuplicateNames(stats.groupings()), RemoveStatsOverride.removeDuplicateNames(stats.aggregates())));
        }
        return p;
    }

    private static <T extends Expression> List<T> removeDuplicateNames(List<T> list) {
        ArrayList<T> newList = new ArrayList<T>(list);
        HashSet nameSet = Sets.newHashSetWithExpectedSize((int)list.size());
        for (int i = list.size() - 1; i >= 0; --i) {
            Expression element = (Expression)list.get(i);
            String name = Expressions.name((Expression)element);
            if (nameSet.add(name)) continue;
            newList.remove(i);
        }
        return newList.size() == list.size() ? list : newList;
    }
}

