/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.AddDefaultTopN;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.BooleanFunctionEqualsElimination;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.BooleanSimplification;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.CombineBinaryComparisons;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.CombineDisjunctions;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.CombineEvals;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.CombineProjections;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ConstantFolding;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ConvertStringToByteRef;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.FoldNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.LiteralsOnTheRight;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PartiallyFoldCase;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEquals;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEvalFoldables;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateNullable;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneColumns;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneEmptyPlans;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneFilters;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneLiteralsInOrderBy;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneOrderByBeforeStats;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneRedundantSortClauses;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownAndCombineFilters;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownAndCombineLimits;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownAndCombineOrderBy;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownEnrich;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownRegexExtract;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.RemoveStatsOverride;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceAliasingEvalWithProject;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceLimitAndSortAsTopN;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceLookupWithJoin;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceOrderByExpressionWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceRegexMatch;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStatsAggExpressionWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStatsNestedExpressionWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceTrivialTypeConversions;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SetAsOptimized;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SimplifyComparisonsArithmetics;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SkipQueryOnEmptyMappings;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SkipQueryOnLimitZero;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SplitInWithFoldableValue;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SubstituteFilteredExpression;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SubstituteSpatialSurrogates;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SubstituteSurrogates;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.TranslateMetricsAggregate;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class LogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LogicalOptimizerContext> {
    private final LogicalVerifier verifier = LogicalVerifier.INSTANCE;

    public LogicalPlanOptimizer(LogicalOptimizerContext optimizerContext) {
        super(optimizerContext);
    }

    public LogicalPlan optimize(LogicalPlan verified) {
        LogicalPlan optimized = this.execute(verified);
        Failures failures = this.verifier.verify(optimized);
        if (failures.hasFailures()) {
            throw new VerificationException(failures);
        }
        optimized.setOptimized();
        return optimized;
    }

    @Override
    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return LogicalPlanOptimizer.rules();
    }

    protected static List<RuleExecutor.Batch<LogicalPlan>> rules() {
        RuleExecutor.Batch skip = new RuleExecutor.Batch("Skip Compute", new SkipQueryOnLimitZero());
        RuleExecutor.Batch defaultTopN = new RuleExecutor.Batch("Add default TopN", new AddDefaultTopN());
        RuleExecutor.Batch label = new RuleExecutor.Batch("Set as Optimized", RuleExecutor.Limiter.ONCE, new SetAsOptimized());
        return Arrays.asList(LogicalPlanOptimizer.substitutions(), LogicalPlanOptimizer.operators(), skip, LogicalPlanOptimizer.cleanup(), defaultTopN, label);
    }

    protected static RuleExecutor.Batch<LogicalPlan> substitutions() {
        return new RuleExecutor.Batch<LogicalPlan>("Substitutions", RuleExecutor.Limiter.ONCE, new ReplaceLookupWithJoin(), new SubstituteFilteredExpression(), new RemoveStatsOverride(), new ReplaceStatsNestedExpressionWithEval(), new ReplaceStatsAggExpressionWithEval(), new SubstituteSurrogates(), new TranslateMetricsAggregate(), new ReplaceStatsNestedExpressionWithEval(), new ReplaceRegexMatch(), new ReplaceTrivialTypeConversions(), new ReplaceAliasingEvalWithProject(), new SkipQueryOnEmptyMappings(), new SubstituteSpatialSurrogates(), new ReplaceOrderByExpressionWithEval());
    }

    protected static RuleExecutor.Batch<LogicalPlan> operators() {
        return new RuleExecutor.Batch<LogicalPlan>("Operator Optimization", new CombineProjections(), new CombineEvals(), new PruneEmptyPlans(), new PropagateEmptyRelation(), new ConvertStringToByteRef(), new FoldNull(), new SplitInWithFoldableValue(), new PropagateEvalFoldables(), new ConstantFolding(), new PartiallyFoldCase(), new BooleanSimplification(), new LiteralsOnTheRight(), new PropagateEquals(), new PropagateNullable(), new BooleanFunctionEqualsElimination(), new CombineBinaryComparisons(), new CombineDisjunctions(), new SimplifyComparisonsArithmetics(DataType::areCompatible), new PruneFilters(), new PruneColumns(), new PruneLiteralsInOrderBy(), new PushDownAndCombineLimits(), new PushDownAndCombineFilters(), new PushDownEval(), new PushDownRegexExtract(), new PushDownEnrich(), new PushDownAndCombineOrderBy(), new PruneOrderByBeforeStats(), new PruneRedundantSortClauses());
    }

    protected static RuleExecutor.Batch<LogicalPlan> cleanup() {
        return new RuleExecutor.Batch<LogicalPlan>("Clean Up", new ReplaceLimitAndSortAsTopN());
    }
}

