/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferIsNotNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferNonNullAggConstraint;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.LocalPropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceMissingFieldWithNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceTopNWithLimitAndSort;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.Rule;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class LocalLogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LocalLogicalOptimizerContext> {
    public LocalLogicalPlanOptimizer(LocalLogicalOptimizerContext localLogicalOptimizerContext) {
        super(localLogicalOptimizerContext);
    }

    @Override
    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        RuleExecutor.Batch local = new RuleExecutor.Batch("Local rewrite", RuleExecutor.Limiter.ONCE, new ReplaceTopNWithLimitAndSort(), new ReplaceMissingFieldWithNull(), new InferIsNotNull(), new InferNonNullAggConstraint());
        ArrayList<RuleExecutor.Batch<LogicalPlan>> rules = new ArrayList<RuleExecutor.Batch<LogicalPlan>>();
        rules.add(local);
        rules.addAll(Arrays.asList(LogicalPlanOptimizer.operators(), LogicalPlanOptimizer.cleanup()));
        this.replaceRules(rules);
        return rules;
    }

    private List<RuleExecutor.Batch<LogicalPlan>> replaceRules(List<RuleExecutor.Batch<LogicalPlan>> listOfRules) {
        for (RuleExecutor.Batch<LogicalPlan> batch : listOfRules) {
            Rule<?, LogicalPlan>[] rules = batch.rules();
            for (int i = 0; i < rules.length; ++i) {
                if (!(rules[i] instanceof PropagateEmptyRelation)) continue;
                rules[i] = new LocalPropagateEmptyRelation();
            }
        }
        return listOfRules;
    }

    public LogicalPlan localOptimize(LogicalPlan plan) {
        return this.execute(plan);
    }
}

