/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.index;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.index.MappingException;

public final class IndexResolution {
    private final EsIndex index;
    @Nullable
    private final String invalid;
    private final Set<String> unavailableClusters;

    public static IndexResolution valid(EsIndex index, Set<String> unavailableClusters) {
        Objects.requireNonNull(index, "index must not be null if it was found");
        Objects.requireNonNull(unavailableClusters, "unavailableClusters must not be null");
        return new IndexResolution(index, null, unavailableClusters);
    }

    public static IndexResolution valid(EsIndex index) {
        return IndexResolution.valid(index, Collections.emptySet());
    }

    public static IndexResolution invalid(String invalid) {
        Objects.requireNonNull(invalid, "invalid must not be null to signal that the index is invalid");
        return new IndexResolution(null, invalid, Collections.emptySet());
    }

    public static IndexResolution notFound(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return IndexResolution.invalid("Unknown index [" + name + "]");
    }

    private IndexResolution(EsIndex index, @Nullable String invalid, Set<String> unavailableClusters) {
        this.index = index;
        this.invalid = invalid;
        this.unavailableClusters = unavailableClusters;
    }

    public boolean matches(String indexName) {
        return this.isValid() && this.index.name().equals(indexName);
    }

    public EsIndex get() {
        if (this.invalid != null) {
            throw new MappingException(this.invalid, new Object[0]);
        }
        return this.index;
    }

    public boolean isValid() {
        return this.invalid == null;
    }

    public Set<String> getUnavailableClusters() {
        return this.unavailableClusters;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IndexResolution other = (IndexResolution)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.invalid, other.invalid) && Objects.equals(this.unavailableClusters, other.unavailableClusters);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.invalid, this.unavailableClusters);
    }

    public String toString() {
        return this.invalid != null ? this.invalid : this.index.name();
    }
}

