/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;

public final class LessThanIntsEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator lhs;
    private final EvalOperator.ExpressionEvaluator rhs;
    private final DriverContext driverContext;
    private Warnings warnings;

    public LessThanIntsEvaluator(Source source, EvalOperator.ExpressionEvaluator lhs, EvalOperator.ExpressionEvaluator rhs, DriverContext driverContext) {
        this.source = source;
        this.lhs = lhs;
        this.rhs = rhs;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock lhsBlock = (IntBlock)this.lhs.eval(page);){
            BooleanBlock booleanBlock;
            block20: {
                IntVector rhsVector;
                IntVector lhsVector;
                IntBlock rhsBlock;
                block18: {
                    BooleanBlock booleanBlock2;
                    block19: {
                        block16: {
                            BooleanBlock booleanBlock3;
                            block17: {
                                rhsBlock = (IntBlock)this.rhs.eval(page);
                                try {
                                    lhsVector = lhsBlock.asVector();
                                    if (lhsVector != null) break block16;
                                    booleanBlock3 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                                    if (rhsBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rhsBlock != null) {
                                        try {
                                            rhsBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rhsBlock.close();
                            }
                            return booleanBlock3;
                        }
                        rhsVector = rhsBlock.asVector();
                        if (rhsVector != null) break block18;
                        booleanBlock2 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                        if (rhsBlock == null) break block19;
                        rhsBlock.close();
                    }
                    return booleanBlock2;
                }
                booleanBlock = this.eval(page.getPositionCount(), lhsVector, rhsVector).asBlock();
                if (rhsBlock == null) break block20;
                rhsBlock.close();
            }
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, IntBlock lhsBlock, IntBlock rhsBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (lhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (lhsBlock.getValueCount(p) != 1) {
                    if (lhsBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.getValueCount(p) != 1) {
                    if (rhsBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(LessThan.processInts(lhsBlock.getInt(lhsBlock.getFirstValueIndex(p)), rhsBlock.getInt(rhsBlock.getFirstValueIndex(p))));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, IntVector lhsVector, IntVector rhsVector) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(p, LessThan.processInts(lhsVector.getInt(p), rhsVector.getInt(p)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "LessThanIntsEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.lhs, this.rhs});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory lhs;
        private final EvalOperator.ExpressionEvaluator.Factory rhs;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory lhs, EvalOperator.ExpressionEvaluator.Factory rhs) {
            this.source = source;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public LessThanIntsEvaluator get(DriverContext context) {
            return new LessThanIntsEvaluator(this.source, this.lhs.get(context), this.rhs.get(context), context);
        }

        public String toString() {
            return "LessThanIntsEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
        }
    }
}

