/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanKeywordsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;

public class GreaterThan
extends EsqlBinaryComparison
implements Negatable<EsqlBinaryComparison> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "GreaterThan", EsqlBinaryComparison::readFrom);
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataType.INTEGER, GreaterThanIntsEvaluator.Factory::new), Map.entry(DataType.DOUBLE, GreaterThanDoublesEvaluator.Factory::new), Map.entry(DataType.LONG, GreaterThanLongsEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, GreaterThanLongsEvaluator.Factory::new), Map.entry(DataType.DATETIME, GreaterThanLongsEvaluator.Factory::new), Map.entry(DataType.DATE_NANOS, GreaterThanLongsEvaluator.Factory::new), Map.entry(DataType.KEYWORD, GreaterThanKeywordsEvaluator.Factory::new), Map.entry(DataType.TEXT, GreaterThanKeywordsEvaluator.Factory::new), Map.entry(DataType.VERSION, GreaterThanKeywordsEvaluator.Factory::new), Map.entry(DataType.IP, GreaterThanKeywordsEvaluator.Factory::new));

    @FunctionInfo(returnType={"boolean"}, description="Check if one field is greater than another. If either field is <<esql-multivalued-fields,multivalued>> then the result is `null`.", note="This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an <<mapping-index>> and <<doc-values>>.")
    public GreaterThan(Source source, @Param(name="lhs", type={"boolean", "date", "double", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="An expression.") Expression left, @Param(name="rhs", type={"boolean", "date", "double", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="An expression.") Expression right) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.GT, evaluatorMap);
    }

    public GreaterThan(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.GT, zoneId, evaluatorMap);
    }

    public String getWriteableName() {
        return GreaterThan.ENTRY.name;
    }

    protected NodeInfo<GreaterThan> info() {
        return NodeInfo.create((Node)this, GreaterThan::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected GreaterThan replaceChildren(Expression newLeft, Expression newRight) {
        return new GreaterThan(this.source(), newLeft, newRight, this.zoneId());
    }

    public LessThan swapLeftAndRight() {
        return new LessThan(this.source(), this.right(), this.left(), this.zoneId());
    }

    public LessThanOrEqual negate() {
        return new LessThanOrEqual(this.source(), this.left(), this.right(), this.zoneId());
    }

    public EsqlBinaryComparison reverse() {
        return new LessThan(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs > rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs > rhs;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs > rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.compareTo(rhs) > 0;
    }
}

