/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public abstract class EsqlBinaryComparison
extends BinaryComparison
implements EvaluatorMapper {
    private final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap;
    private final BinaryComparisonOperation functionType;

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(Equals.ENTRY, GreaterThan.ENTRY, GreaterThanOrEqual.ENTRY, LessThan.ENTRY, LessThanOrEqual.ENTRY, NotEquals.ENTRY);
    }

    protected EsqlBinaryComparison(Source source, Expression left, Expression right, BinaryComparisonOperation operation, Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap) {
        this(source, left, right, operation, null, evaluatorMap);
    }

    protected EsqlBinaryComparison(Source source, Expression left, Expression right, BinaryComparisonOperation operation, ZoneId zoneId, Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap) {
        super(source, left, right, operation.shim, zoneId);
        this.evaluatorMap = evaluatorMap;
        this.functionType = operation;
    }

    public static EsqlBinaryComparison readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        BinaryComparisonOperation operation = BinaryComparisonOperation.readFromStream(in);
        Expression left = (Expression)in.readNamedWriteable(Expression.class);
        Expression right = (Expression)in.readNamedWriteable(Expression.class);
        ZoneId zoneId = in.readOptionalZoneId();
        return operation.buildNewInstance(source, left, right);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        this.functionType.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.left());
        out.writeNamedWriteable((NamedWriteable)this.right());
        out.writeOptionalZoneId(this.zoneId());
    }

    public BinaryComparisonOperation getFunctionType() {
        return this.functionType;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory rhs;
        EvalOperator.ExpressionEvaluator.Factory lhs;
        DataType commonType = EsqlDataTypeConverter.commonType(this.left().dataType(), this.right().dataType());
        if (commonType.isNumeric()) {
            lhs = Cast.cast(this.source(), this.left().dataType(), commonType, toEvaluator.apply(this.left()));
            rhs = Cast.cast(this.source(), this.right().dataType(), commonType, toEvaluator.apply(this.right()));
        } else {
            lhs = toEvaluator.apply(this.left());
            rhs = toEvaluator.apply(this.right());
        }
        if (!this.evaluatorMap.containsKey(commonType)) {
            throw new EsqlIllegalArgumentException("Unsupported type " + this.left().dataType());
        }
        return this.evaluatorMap.get(commonType).apply(this.source(), lhs, rhs);
    }

    @Override
    public Boolean fold() {
        return (Boolean)EvaluatorMapper.super.fold();
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution typeResolution = super.resolveType();
        if (typeResolution.unresolved()) {
            return typeResolution;
        }
        return this.checkCompatibility();
    }

    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isType((Expression)e, this.evaluatorMap::containsKey, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)paramOrdinal, (String[])((String[])this.evaluatorMap.keySet().stream().map(DataType::typeName).sorted().toArray(String[]::new)));
    }

    protected Expression.TypeResolution checkCompatibility() {
        DataType leftType = this.left().dataType();
        DataType rightType = this.right().dataType();
        if (rightType == DataType.UNSIGNED_LONG && !(leftType == DataType.UNSIGNED_LONG || leftType == DataType.NULL) || leftType == DataType.UNSIGNED_LONG && !(rightType == DataType.UNSIGNED_LONG || rightType == DataType.NULL)) {
            return new Expression.TypeResolution(this.formatIncompatibleTypesMessage());
        }
        if (leftType.isNumeric() && rightType.isNumeric() || DataType.isString((DataType)leftType) && DataType.isString((DataType)rightType) || leftType.equals((Object)rightType) || DataType.isNull((DataType)leftType) || DataType.isNull((DataType)rightType)) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution(this.formatIncompatibleTypesMessage());
    }

    public String formatIncompatibleTypesMessage() {
        if (this.left().dataType().equals((Object)DataType.UNSIGNED_LONG)) {
            return LoggerMessageFormat.format(null, (String)"first argument of [{}] is [unsigned_long] and second is [{}]. [unsigned_long] can only be operated on together with another [unsigned_long]", (Object[])new Object[]{this.sourceText(), this.right().dataType().typeName()});
        }
        if (this.right().dataType().equals((Object)DataType.UNSIGNED_LONG)) {
            return LoggerMessageFormat.format(null, (String)"first argument of [{}] is [{}] and second is [unsigned_long]. [unsigned_long] can only be operated on together with another [unsigned_long]", (Object[])new Object[]{this.sourceText(), this.left().dataType().typeName()});
        }
        return LoggerMessageFormat.format(null, (String)"first argument of [{}] is [{}] so second argument must also be [{}] but was [{}]", (Object[])new Object[]{this.sourceText(), this.left().dataType().isNumeric() ? "numeric" : this.left().dataType().typeName(), this.left().dataType().isNumeric() ? "numeric" : this.left().dataType().typeName(), this.right().dataType().typeName()});
    }

    public static enum BinaryComparisonOperation implements Writeable
    {
        EQ(0, "==", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.EQ, Equals::new),
        NEQ(2, "!=", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.NEQ, NotEquals::new),
        GT(3, ">", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.GT, GreaterThan::new),
        GTE(4, ">=", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.GTE, GreaterThanOrEqual::new),
        LT(5, "<", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.LT, LessThan::new),
        LTE(6, "<=", org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation.LTE, LessThanOrEqual::new);

        private final int id;
        private final String symbol;
        private final org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation shim;
        private final BinaryOperatorConstructor constructor;

        private BinaryComparisonOperation(int id, String symbol, org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparisonOperation shim, BinaryOperatorConstructor constructor) {
            this.id = id;
            this.symbol = symbol;
            this.shim = shim;
            this.constructor = constructor;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.id);
        }

        public static BinaryComparisonOperation readFromStream(StreamInput in) throws IOException {
            int id = in.readVInt();
            for (BinaryComparisonOperation op : BinaryComparisonOperation.values()) {
                if (op.id != id) continue;
                return op;
            }
            throw new IOException("No BinaryComparisonOperation found for id [" + id + "]");
        }

        public String symbol() {
            return this.symbol;
        }

        public EsqlBinaryComparison buildNewInstance(Source source, Expression lhs, Expression rhs) {
            return this.constructor.apply(source, lhs, rhs);
        }
    }

    @FunctionalInterface
    public static interface BinaryOperatorConstructor {
        public EsqlBinaryComparison apply(Source var1, Expression var2, Expression var3);
    }
}

