/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Neg;

public final class NegIntsEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;
    private Warnings warnings;

    public NegIntsEvaluator(Source source, EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.source = source;
        this.v = v;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock vBlock = (IntBlock)this.v.eval(page);){
            IntVector vVector = vBlock.asVector();
            if (vVector == null) {
                IntBlock intBlock = this.eval(page.getPositionCount(), vBlock);
                return intBlock;
            }
            IntBlock intBlock = this.eval(page.getPositionCount(), vVector);
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, IntBlock vBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (vBlock.getValueCount(p) != 1) {
                    if (vBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendInt(Neg.processInts(vBlock.getInt(vBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, IntVector vVector) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendInt(Neg.processInts(vVector.getInt(p)));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "NegIntsEvaluator[v=" + this.v + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory v;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory v) {
            this.source = source;
            this.v = v;
        }

        public NegIntsEvaluator get(DriverContext context) {
            return new NegIntsEvaluator(this.source, this.v.get(context), context);
        }

        public String toString() {
            return "NegIntsEvaluator[v=" + this.v + "]";
        }
    }
}

