/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.time.Duration;
import java.time.Period;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.ExceptionUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.NegDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.NegIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.NegLongsEvaluator;

public class Neg
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Neg", Neg::new);

    @FunctionInfo(returnType={"double", "integer", "long", "date_period", "time_duration"}, description="Returns the negation of the argument.")
    public Neg(Source source, @Param(name="field", description="A numeric value or a date time interval.", type={"double", "integer", "long", "date_period", "time_duration"}) Expression field) {
        super(source, field);
    }

    public Neg(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Neg.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        DataType type = this.dataType();
        if (type.isNumeric()) {
            EvalOperator.ExpressionEvaluator.Factory f = toEvaluator.apply(this.field());
            Object factory = null;
            if (type == DataType.INTEGER) {
                factory = new NegIntsEvaluator.Factory(this.source(), f);
            } else if (type == DataType.LONG) {
                factory = new NegLongsEvaluator.Factory(this.source(), f);
            } else if (type == DataType.DOUBLE) {
                factory = new NegDoublesEvaluator.Factory(this.source(), f);
            }
            if (factory != null) {
                return factory;
            }
        } else if (DataType.isTemporalAmount((DataType)type)) {
            return toEvaluator.apply(this.field());
        }
        throw new EsqlIllegalArgumentException("arithmetic negation operator with unsupported data type [" + type + "]");
    }

    @Override
    public final Object fold() {
        DataType dataType = this.field().dataType();
        if (dataType == DataType.DATE_PERIOD) {
            Period fieldValue = (Period)this.field().fold();
            try {
                return fieldValue.negated();
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        if (dataType == DataType.TIME_DURATION) {
            Duration fieldValue = (Duration)this.field().fold();
            try {
                return fieldValue.negated();
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        return super.fold();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt != DataType.UNSIGNED_LONG && (dt.isNumeric() || DataType.isTemporalAmount((DataType)dt)), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric", "date_period", "time_duration"});
    }

    protected NodeInfo<Neg> info() {
        return NodeInfo.create((Node)this, Neg::new, (Object)this.field());
    }

    public Neg replaceChildren(List<Expression> newChildren) {
        return new Neg(this.source(), newChildren.get(0));
    }

    static int processInts(int v) {
        return Math.negateExact(v);
    }

    static long processLongs(long v) {
        return Math.negateExact(v);
    }

    static double processDoubles(double v) {
        return -v;
    }
}

