/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ReverseEvaluator;

public class Reverse
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Reverse", Reverse::new);

    @FunctionInfo(returnType={"keyword", "text"}, description="Returns a new string representing the input string in reverse order.", examples={@Example(file="string", tag="reverse"), @Example(file="string", tag="reverseEmoji", description="`REVERSE` works with unicode, too! It keeps unicode grapheme clusters together during reversal.")}, note="If Elasticsearch is running with a JDK version less than 20 then this will not properly reverse Grapheme Clusters.\nElastic Cloud and the JDK bundled with Elasticsearch all use newer JDKs. But if you've explicitly shifted to an older jdk\nthen you'll see things like \"\ud83d\udc4d\ud83c\udffd\ud83d\ude0a\" be reversed to  \"\ud83c\udffd\ud83d\udc4d\ud83d\ude0a\" instead of the correct \"\ud83d\ude0a\ud83d\udc4d\ud83c\udffd\".")
    public Reverse(Source source, @Param(name="str", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression field) {
        super(source, field);
    }

    private Reverse(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Reverse.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public static String reverseStringWithUnicodeCharacters(String str) {
        BreakIterator boundary = BreakIterator.getCharacterInstance(Locale.ROOT);
        boundary.setText(str);
        ArrayList<String> characters = new ArrayList<String>();
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            characters.add(str.substring(start, end));
            start = end;
            end = boundary.next();
        }
        StringBuilder reversed = new StringBuilder(str.length());
        for (int i = characters.size() - 1; i >= 0; --i) {
            reversed.append((String)characters.get(i));
        }
        return reversed.toString();
    }

    private static boolean reverseBytesIsReverseUnicode(BytesRef ref) {
        int end = ref.offset + ref.length;
        for (int i = ref.offset; i < end; ++i) {
            if (ref.bytes[i] >= 0 && ref.bytes[i] != 40) continue;
            return false;
        }
        return true;
    }

    static BytesRef process(BytesRef val) {
        if (Reverse.reverseBytesIsReverseUnicode(val)) {
            BytesRef reversed = BytesRef.deepCopyOf((BytesRef)val);
            ArrayUtils.reverseArray((byte[])reversed.bytes, (int)reversed.offset, (int)reversed.length);
            return reversed;
        }
        return new BytesRef((CharSequence)Reverse.reverseStringWithUnicodeCharacters(val.utf8ToString()));
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        return new ReverseEvaluator.Factory(this.source(), fieldEvaluator);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        assert (newChildren.size() == 1);
        return new Reverse(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Reverse::new, (Object)this.field);
    }
}

