/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.RepeatConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.RepeatEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Repeat
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Repeat", Repeat::new);
    static final long MAX_REPEATED_LENGTH = ByteSizeUnit.MB.toBytes(1L);
    private final Expression str;
    private final Expression number;

    @FunctionInfo(returnType={"keyword"}, description="Returns a string constructed by concatenating `string` with itself the specified `number` of times.", examples={@Example(file="string", tag="repeat")})
    public Repeat(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression.") Expression str, @Param(name="number", type={"integer"}, description="Number times to repeat.") Expression number) {
        super(source, Arrays.asList(str, number));
        this.str = str;
        this.number = number;
    }

    private Repeat(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.str);
        out.writeNamedWriteable((NamedWriteable)this.number);
    }

    public String getWriteableName() {
        return Repeat.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.str, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isType((Expression)this.number, dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integer"});
    }

    public boolean foldable() {
        return this.str.foldable() && this.number.foldable();
    }

    static BytesRef processConstantNumber(BreakingBytesRefBuilder scratch, BytesRef str, int number) {
        return Repeat.processInner(scratch, str, number);
    }

    static BytesRef process(BreakingBytesRefBuilder scratch, BytesRef str, int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Number parameter cannot be negative, found [" + number + "]");
        }
        return Repeat.processInner(scratch, str, number);
    }

    static BytesRef processInner(BreakingBytesRefBuilder scratch, BytesRef str, int number) {
        int repeatedLen = str.length * number;
        if ((long)repeatedLen > MAX_REPEATED_LENGTH) {
            throw new IllegalArgumentException("Creating repeated strings with more than [" + MAX_REPEATED_LENGTH + "] bytes is not supported");
        }
        scratch.grow(repeatedLen);
        scratch.clear();
        for (int i = 0; i < number; ++i) {
            scratch.append(str);
        }
        return scratch.bytesRefView();
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Repeat(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Repeat::new, (Object)this.str, (Object)this.number);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory strExpr = toEvaluator.apply(this.str);
        if (this.number.foldable()) {
            int num = (Integer)this.number.fold();
            if (num < 0) {
                throw new IllegalArgumentException("Number parameter cannot be negative, found [" + this.number + "]");
            }
            return new RepeatConstantEvaluator.Factory(this.source(), context -> new BreakingBytesRefBuilder(context.breaker(), "repeat"), strExpr, num);
        }
        EvalOperator.ExpressionEvaluator.Factory numberExpr = toEvaluator.apply(this.number);
        return new RepeatEvaluator.Factory(this.source(), context -> new BreakingBytesRefBuilder(context.breaker(), "repeat"), strExpr, numberExpr);
    }

    Expression str() {
        return this.str;
    }

    Expression number() {
        return this.number;
    }
}

