/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Locate;

public final class LocateEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator substr;
    private final EvalOperator.ExpressionEvaluator start;
    private final DriverContext driverContext;
    private Warnings warnings;

    public LocateEvaluator(Source source, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator substr, EvalOperator.ExpressionEvaluator start, DriverContext driverContext) {
        this.source = source;
        this.str = str;
        this.substr = substr;
        this.start = start;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IntBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock substrBlock, IntBlock startBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef substrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (substrBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (substrBlock.getValueCount(p) != 1) {
                    if (substrBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (startBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (startBlock.getValueCount(p) != 1) {
                    if (startBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendInt(Locate.process(strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), substrBlock.getBytesRef(substrBlock.getFirstValueIndex(p), substrScratch), startBlock.getInt(startBlock.getFirstValueIndex(p))));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, BytesRefVector strVector, BytesRefVector substrVector, IntVector startVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef substrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendInt(p, Locate.process(strVector.getBytesRef(p, strScratch), substrVector.getBytesRef(p, substrScratch), startVector.getInt(p)));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "LocateEvaluator[str=" + this.str + ", substr=" + this.substr + ", start=" + this.start + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.substr, this.start});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory substr;
        private final EvalOperator.ExpressionEvaluator.Factory start;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory substr, EvalOperator.ExpressionEvaluator.Factory start) {
            this.source = source;
            this.str = str;
            this.substr = substr;
            this.start = start;
        }

        public LocateEvaluator get(DriverContext context) {
            return new LocateEvaluator(this.source, this.str.get(context), this.substr.get(context), this.start.get(context), context);
        }

        public String toString() {
            return "LocateEvaluator[str=" + this.str + ", substr=" + this.substr + ", start=" + this.start + "]";
        }
    }
}

