/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistance;

public final class StDistanceCartesianPointDocValuesAndSourceEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator left;
    private final EvalOperator.ExpressionEvaluator right;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StDistanceCartesianPointDocValuesAndSourceEvaluator(Source source, EvalOperator.ExpressionEvaluator left, EvalOperator.ExpressionEvaluator right, DriverContext driverContext) {
        this.source = source;
        this.left = left;
        this.right = right;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock leftBlock = (LongBlock)this.left.eval(page);){
            DoubleBlock doubleBlock;
            block12: {
                BytesRefBlock rightBlock = (BytesRefBlock)this.right.eval(page);
                try {
                    doubleBlock = this.eval(page.getPositionCount(), leftBlock, rightBlock);
                    if (rightBlock == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rightBlock != null) {
                        try {
                            rightBlock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rightBlock.close();
            }
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, LongBlock leftBlock, BytesRefBlock rightBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!leftBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!rightBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                StDistance.processCartesianPointDocValuesAndSource(result, p, leftBlock, rightBlock);
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "StDistanceCartesianPointDocValuesAndSourceEvaluator[left=" + this.left + ", right=" + this.right + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.left, this.right});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory left;
        private final EvalOperator.ExpressionEvaluator.Factory right;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory left, EvalOperator.ExpressionEvaluator.Factory right) {
            this.source = source;
            this.left = left;
            this.right = right;
        }

        public StDistanceCartesianPointDocValuesAndSourceEvaluator get(DriverContext context) {
            return new StDistanceCartesianPointDocValuesAndSourceEvaluator(this.source, this.left.get(context), this.right.get(context), context);
        }

        public String toString() {
            return "StDistanceCartesianPointDocValuesAndSourceEvaluator[left=" + this.left + ", right=" + this.right + "]";
        }
    }
}

