/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;

public final class MvMinDoubleEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvMinDoubleEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvMin";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                double value = v.getDouble(first);
                for (int i = first + 1; i < end; ++i) {
                    double next = v.getDouble(i);
                    value = MvMin.process(value, next);
                }
                double result = value;
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                double value = v.getDouble(first);
                for (int i = first + 1; i < end; ++i) {
                    double next = v.getDouble(i);
                    value = MvMin.process(value, next);
                }
                double result = value;
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int idx = MvMin.ascendingIndex(valueCount);
                double result = v.getDouble(first + idx);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int idx = MvMin.ascendingIndex(valueCount);
                double result = v.getDouble(first + idx);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMinDoubleEvaluator get(DriverContext context) {
            return new MvMinDoubleEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMin[field=" + this.field + "]";
        }
    }
}

