/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedianAbsoluteDeviation;

public final class MvMedianAbsoluteDeviationLongEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvMedianAbsoluteDeviationLongEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvMedianAbsoluteDeviation";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                if (valueCount == 1) {
                    long value = v.getLong(first);
                    long result = MvMedianAbsoluteDeviation.single(value);
                    builder.appendLong(result);
                    continue;
                }
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    long value = v.getLong(i);
                    MvMedianAbsoluteDeviation.process(work, value);
                }
                long result = MvMedianAbsoluteDeviation.finish(work);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongVector.FixedBuilder builder = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                if (valueCount == 1) {
                    long value = v.getLong(first);
                    long result = MvMedianAbsoluteDeviation.single(value);
                    builder.appendLong(result);
                    continue;
                }
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    long value = v.getLong(i);
                    MvMedianAbsoluteDeviation.process(work, value);
                }
                long result = MvMedianAbsoluteDeviation.finish(work);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build().asBlock();
            return longBlock;
        }
    }

    @Override
    public Block evalSingleValuedNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                assert (valueCount == 1);
                int first = v.getFirstValueIndex(p);
                long value = v.getLong(first);
                long result = MvMedianAbsoluteDeviation.single(value);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    @Override
    public Block evalSingleValuedNotNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongVector.FixedBuilder builder = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                assert (valueCount == 1);
                int first = v.getFirstValueIndex(p);
                long value = v.getLong(first);
                long result = MvMedianAbsoluteDeviation.single(value);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build().asBlock();
            return longBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                long result = MvMedianAbsoluteDeviation.ascending(work, v, first, valueCount);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (LongVector.FixedBuilder builder = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                long result = MvMedianAbsoluteDeviation.ascending(work, v, first, valueCount);
                builder.appendLong(result);
            }
            LongBlock longBlock = builder.build().asBlock();
            return longBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMedianAbsoluteDeviationLongEvaluator get(DriverContext context) {
            return new MvMedianAbsoluteDeviationLongEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMedianAbsoluteDeviation[field=" + this.field + "]";
        }
    }
}

