/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedianAbsoluteDeviation;

public final class MvMedianAbsoluteDeviationDoubleEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvMedianAbsoluteDeviationDoubleEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvMedianAbsoluteDeviation";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Doubles work = new MvMedianAbsoluteDeviation.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                if (valueCount == 1) {
                    double value = v.getDouble(first);
                    double result = MvMedianAbsoluteDeviation.single(value);
                    builder.appendDouble(result);
                    continue;
                }
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    double value = v.getDouble(i);
                    MvMedianAbsoluteDeviation.process(work, value);
                }
                double result = MvMedianAbsoluteDeviation.finish(work);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Doubles work = new MvMedianAbsoluteDeviation.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                if (valueCount == 1) {
                    double value = v.getDouble(first);
                    double result = MvMedianAbsoluteDeviation.single(value);
                    builder.appendDouble(result);
                    continue;
                }
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    double value = v.getDouble(i);
                    MvMedianAbsoluteDeviation.process(work, value);
                }
                double result = MvMedianAbsoluteDeviation.finish(work);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    @Override
    public Block evalSingleValuedNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Doubles work = new MvMedianAbsoluteDeviation.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                assert (valueCount == 1);
                int first = v.getFirstValueIndex(p);
                double value = v.getDouble(first);
                double result = MvMedianAbsoluteDeviation.single(value);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    @Override
    public Block evalSingleValuedNotNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Doubles work = new MvMedianAbsoluteDeviation.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                assert (valueCount == 1);
                int first = v.getFirstValueIndex(p);
                double value = v.getDouble(first);
                double result = MvMedianAbsoluteDeviation.single(value);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Doubles work = new MvMedianAbsoluteDeviation.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                double result = MvMedianAbsoluteDeviation.ascending(work, v, first, valueCount);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        DoubleBlock v = (DoubleBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Doubles work = new MvMedianAbsoluteDeviation.Doubles();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                double result = MvMedianAbsoluteDeviation.ascending(work, v, first, valueCount);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMedianAbsoluteDeviationDoubleEvaluator get(DriverContext context) {
            return new MvMedianAbsoluteDeviationDoubleEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMedianAbsoluteDeviation[field=" + this.field + "]";
        }
    }
}

