/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMaxLongEvaluator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvMax
extends AbstractMultivalueFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvMax", MvMax::new);

    @FunctionInfo(returnType={"boolean", "date", "date_nanos", "double", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Converts a multivalued expression into a single valued column containing the maximum value.", examples={@Example(file="math", tag="mv_max"), @Example(description="It can be used by any column type, including `keyword` columns. In that case it picks the last string, comparing their utf-8 representation byte by byte:", file="string", tag="mv_max")})
    public MvMax(Source source, @Param(name="field", type={"boolean", "date", "date_nanos", "double", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression.") Expression v) {
        super(source, v);
    }

    private MvMax(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MvMax.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), t -> !DataType.isSpatial((DataType)t) && DataType.isRepresentable((DataType)t), (String)this.sourceText(), null, (String[])new String[]{"representableNonSpatial"});
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return switch (PlannerUtils.toSortableElementType(this.field().dataType())) {
            case ElementType.BOOLEAN -> new MvMaxBooleanEvaluator.Factory(fieldEval);
            case ElementType.BYTES_REF -> new MvMaxBytesRefEvaluator.Factory(fieldEval);
            case ElementType.DOUBLE -> new MvMaxDoubleEvaluator.Factory(fieldEval);
            case ElementType.INT -> new MvMaxIntEvaluator.Factory(fieldEval);
            case ElementType.LONG -> new MvMaxLongEvaluator.Factory(fieldEval);
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvMax(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvMax::new, (Object)this.field());
    }

    static boolean process(boolean current, boolean v) {
        return current || v;
    }

    static void process(BytesRef current, BytesRef v) {
        if (v.compareTo(current) > 0) {
            current.bytes = v.bytes;
            current.offset = v.offset;
            current.length = v.length;
        }
    }

    static double process(double current, double v) {
        return Math.max(current, v);
    }

    static int process(int current, int v) {
        return Math.max(current, v);
    }

    static long process(long current, long v) {
        return Math.max(current, v);
    }

    static int ascendingIndex(int count) {
        return count - 1;
    }
}

