/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAppend;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvg;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvConcat;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvCount;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvDedupe;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirst;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLast;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedianAbsoluteDeviation;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPSeriesWeightedSum;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPercentile;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSlice;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSort;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvZip;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public abstract class AbstractMultivalueFunction
extends UnaryScalarFunction {
    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(MvAppend.ENTRY, MvAvg.ENTRY, MvConcat.ENTRY, MvCount.ENTRY, MvDedupe.ENTRY, MvFirst.ENTRY, MvLast.ENTRY, MvMax.ENTRY, MvMedian.ENTRY, MvMedianAbsoluteDeviation.ENTRY, MvMin.ENTRY, MvPercentile.ENTRY, MvPSeriesWeightedSum.ENTRY, MvSlice.ENTRY, MvSort.ENTRY, MvSum.ENTRY, MvZip.ENTRY);
    }

    protected AbstractMultivalueFunction(Source source, Expression field) {
        super(source, field);
    }

    protected AbstractMultivalueFunction(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class));
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
    }

    protected abstract EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory var1);

    @Override
    protected final Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return this.resolveFieldType();
    }

    protected abstract Expression.TypeResolution resolveFieldType();

    @Override
    public final EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return this.evaluator(toEvaluator.apply(this.field()));
    }

    public static abstract class AbstractNullableEvaluator
    implements EvalOperator.ExpressionEvaluator {
        protected final DriverContext driverContext;
        protected final EvalOperator.ExpressionEvaluator field;

        protected AbstractNullableEvaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field) {
            this.driverContext = driverContext;
            this.field = field;
        }

        protected abstract String name();

        protected abstract Block evalNullable(Block var1);

        protected Block evalSingleValuedNullable(Block fieldRef) {
            fieldRef.incRef();
            return fieldRef;
        }

        public Block eval(Page page) {
            try (Block block = this.field.eval(page);){
                if (block.mayHaveMultivaluedFields()) {
                    Block block2 = this.evalNullable(block);
                    return block2;
                }
                Block block3 = this.evalSingleValuedNullable(block);
                return block3;
            }
        }

        public final String toString() {
            return this.name() + "[field=" + this.field + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.field);
        }
    }

    public static abstract class AbstractEvaluator
    extends AbstractNullableEvaluator {
        protected AbstractEvaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field) {
            super(driverContext, field);
        }

        protected abstract Block evalNotNullable(Block var1);

        protected Block evalSingleValuedNotNullable(Block fieldRef) {
            fieldRef.incRef();
            return fieldRef;
        }

        @Override
        public final Block eval(Page page) {
            try (Block block = this.field.eval(page);){
                if (block.mayHaveMultivaluedFields()) {
                    if (block.mayHaveNulls()) {
                        Block block2 = this.evalNullable(block);
                        return block2;
                    }
                    Block block3 = this.evalNotNullable(block);
                    return block3;
                }
                if (block.mayHaveNulls()) {
                    Block block4 = this.evalSingleValuedNullable(block);
                    return block4;
                }
                Block block5 = this.evalSingleValuedNotNullable(block);
                return block5;
            }
        }
    }
}

