/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Pow;

public final class PowEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator base;
    private final EvalOperator.ExpressionEvaluator exponent;
    private final DriverContext driverContext;
    private Warnings warnings;

    public PowEvaluator(Source source, EvalOperator.ExpressionEvaluator base, EvalOperator.ExpressionEvaluator exponent, DriverContext driverContext) {
        this.source = source;
        this.base = base;
        this.exponent = exponent;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock baseBlock = (DoubleBlock)this.base.eval(page);){
            DoubleBlock doubleBlock;
            block20: {
                DoubleVector exponentVector;
                DoubleVector baseVector;
                DoubleBlock exponentBlock;
                block18: {
                    DoubleBlock doubleBlock2;
                    block19: {
                        block16: {
                            DoubleBlock doubleBlock3;
                            block17: {
                                exponentBlock = (DoubleBlock)this.exponent.eval(page);
                                try {
                                    baseVector = baseBlock.asVector();
                                    if (baseVector != null) break block16;
                                    doubleBlock3 = this.eval(page.getPositionCount(), baseBlock, exponentBlock);
                                    if (exponentBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (exponentBlock != null) {
                                        try {
                                            exponentBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                exponentBlock.close();
                            }
                            return doubleBlock3;
                        }
                        exponentVector = exponentBlock.asVector();
                        if (exponentVector != null) break block18;
                        doubleBlock2 = this.eval(page.getPositionCount(), baseBlock, exponentBlock);
                        if (exponentBlock == null) break block19;
                        exponentBlock.close();
                    }
                    return doubleBlock2;
                }
                doubleBlock = this.eval(page.getPositionCount(), baseVector, exponentVector);
                if (exponentBlock == null) break block20;
                exponentBlock.close();
            }
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock baseBlock, DoubleBlock exponentBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (baseBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (baseBlock.getValueCount(p) != 1) {
                    if (baseBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (exponentBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (exponentBlock.getValueCount(p) != 1) {
                    if (exponentBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendDouble(Pow.process(baseBlock.getDouble(baseBlock.getFirstValueIndex(p)), exponentBlock.getDouble(exponentBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleVector baseVector, DoubleVector exponentVector) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendDouble(Pow.process(baseVector.getDouble(p), exponentVector.getDouble(p)));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "PowEvaluator[base=" + this.base + ", exponent=" + this.exponent + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.base, this.exponent});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory base;
        private final EvalOperator.ExpressionEvaluator.Factory exponent;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory base, EvalOperator.ExpressionEvaluator.Factory exponent) {
            this.source = source;
            this.base = base;
            this.exponent = exponent;
        }

        public PowEvaluator get(DriverContext context) {
            return new PowEvaluator(this.source, this.base.get(context), this.exponent.get(context), context);
        }

        public String toString() {
            return "PowEvaluator[base=" + this.base + ", exponent=" + this.exponent + "]";
        }
    }
}

