/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Exp;

public final class ExpUnsignedLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ExpUnsignedLongEvaluator(Source source, EvalOperator.ExpressionEvaluator val, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock valBlock = (LongBlock)this.val.eval(page);){
            LongVector valVector = valBlock.asVector();
            if (valVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valVector).asBlock();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, LongBlock valBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Exp.processUnsignedLong(valBlock.getLong(valBlock.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, LongVector valVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(p, Exp.processUnsignedLong(valVector.getLong(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "ExpUnsignedLongEvaluator[val=" + this.val + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val) {
            this.source = source;
            this.val = val;
        }

        public ExpUnsignedLongEvaluator get(DriverContext context) {
            return new ExpUnsignedLongEvaluator(this.source, this.val.get(context), context);
        }

        public String toString() {
            return "ExpUnsignedLongEvaluator[val=" + this.val + "]";
        }
    }
}

