/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan2;

public final class Atan2Evaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator y;
    private final EvalOperator.ExpressionEvaluator x;
    private final DriverContext driverContext;
    private Warnings warnings;

    public Atan2Evaluator(Source source, EvalOperator.ExpressionEvaluator y, EvalOperator.ExpressionEvaluator x, DriverContext driverContext) {
        this.source = source;
        this.y = y;
        this.x = x;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock yBlock = (DoubleBlock)this.y.eval(page);){
            DoubleBlock doubleBlock;
            block20: {
                DoubleVector xVector;
                DoubleVector yVector;
                DoubleBlock xBlock;
                block18: {
                    DoubleBlock doubleBlock2;
                    block19: {
                        block16: {
                            DoubleBlock doubleBlock3;
                            block17: {
                                xBlock = (DoubleBlock)this.x.eval(page);
                                try {
                                    yVector = yBlock.asVector();
                                    if (yVector != null) break block16;
                                    doubleBlock3 = this.eval(page.getPositionCount(), yBlock, xBlock);
                                    if (xBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (xBlock != null) {
                                        try {
                                            xBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                xBlock.close();
                            }
                            return doubleBlock3;
                        }
                        xVector = xBlock.asVector();
                        if (xVector != null) break block18;
                        doubleBlock2 = this.eval(page.getPositionCount(), yBlock, xBlock);
                        if (xBlock == null) break block19;
                        xBlock.close();
                    }
                    return doubleBlock2;
                }
                doubleBlock = this.eval(page.getPositionCount(), yVector, xVector).asBlock();
                if (xBlock == null) break block20;
                xBlock.close();
            }
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock yBlock, DoubleBlock xBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (yBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (yBlock.getValueCount(p) != 1) {
                    if (yBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (xBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (xBlock.getValueCount(p) != 1) {
                    if (xBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Atan2.process(yBlock.getDouble(yBlock.getFirstValueIndex(p)), xBlock.getDouble(xBlock.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector yVector, DoubleVector xVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(p, Atan2.process(yVector.getDouble(p), xVector.getDouble(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "Atan2Evaluator[y=" + this.y + ", x=" + this.x + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.y, this.x});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory y;
        private final EvalOperator.ExpressionEvaluator.Factory x;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory y, EvalOperator.ExpressionEvaluator.Factory x) {
            this.source = source;
            this.y = y;
            this.x = x;
        }

        public Atan2Evaluator get(DriverContext context) {
            return new Atan2Evaluator(this.source, this.y.get(context), this.x.get(context), context);
        }

        public String toString() {
            return "Atan2Evaluator[y=" + this.y + ", x=" + this.x + "]";
        }
    }
}

