/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Abs;

public final class AbsDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator fieldVal;
    private final DriverContext driverContext;
    private Warnings warnings;

    public AbsDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator fieldVal, DriverContext driverContext) {
        this.source = source;
        this.fieldVal = fieldVal;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock fieldValBlock = (DoubleBlock)this.fieldVal.eval(page);){
            DoubleVector fieldValVector = fieldValBlock.asVector();
            if (fieldValVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), fieldValBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), fieldValVector).asBlock();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock fieldValBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (fieldValBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (fieldValBlock.getValueCount(p) != 1) {
                    if (fieldValBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Abs.process(fieldValBlock.getDouble(fieldValBlock.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector fieldValVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(p, Abs.process(fieldValVector.getDouble(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "AbsDoubleEvaluator[fieldVal=" + this.fieldVal + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.fieldVal);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory fieldVal;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory fieldVal) {
            this.source = source;
            this.fieldVal = fieldVal;
        }

        public AbsDoubleEvaluator get(DriverContext context) {
            return new AbsDoubleEvaluator(this.source, this.fieldVal.get(context), context);
        }

        public String toString() {
            return "AbsDoubleEvaluator[fieldVal=" + this.fieldVal + "]";
        }
    }
}

