/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.io.IOException;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTruncEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class DateTrunc
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DateTrunc", DateTrunc::new);
    private final Expression interval;
    private final Expression timestampField;
    protected static final ZoneId DEFAULT_TZ = ZoneOffset.UTC;

    @FunctionInfo(returnType={"date"}, description="Rounds down a date to the closest interval.", examples={@Example(file="date", tag="docsDateTrunc"), @Example(description="Combine `DATE_TRUNC` with <<esql-stats-by>> to create date histograms. For\nexample, the number of hires per year:", file="date", tag="docsDateTruncHistogram"), @Example(description="Or an hourly error rate:", file="conditional", tag="docsCaseHourlyErrorRate")})
    public DateTrunc(Source source, @Param(name="interval", type={"date_period", "time_duration"}, description="Interval; expressed using the timespan literal syntax.") Expression interval, @Param(name="date", type={"date"}, description="Date expression") Expression field) {
        super(source, List.of(interval, field));
        this.interval = interval;
        this.timestampField = field;
    }

    private DateTrunc(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.interval);
        out.writeNamedWriteable((NamedWriteable)this.timestampField);
    }

    public String getWriteableName() {
        return DateTrunc.ENTRY.name;
    }

    Expression interval() {
        return this.interval;
    }

    Expression field() {
        return this.timestampField;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.interval, DataType::isTemporalAmount, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"dateperiod", "timeduration"}).and(TypeResolutions.isDate((Expression)this.timestampField, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    public DataType dataType() {
        return DataType.DATETIME;
    }

    static long process(long fieldVal, Rounding.Prepared rounding) {
        return rounding.round(fieldVal);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateTrunc(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DateTrunc::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)));
    }

    public boolean foldable() {
        return this.interval.foldable() && this.timestampField.foldable();
    }

    static Rounding.Prepared createRounding(Object interval) {
        return DateTrunc.createRounding(interval, DEFAULT_TZ);
    }

    public static Rounding.Prepared createRounding(Object interval, ZoneId timeZone) {
        if (interval instanceof Period) {
            Period period = (Period)interval;
            return DateTrunc.createRounding(period, timeZone);
        }
        if (interval instanceof Duration) {
            Duration duration = (Duration)interval;
            return DateTrunc.createRounding(duration, timeZone);
        }
        throw new IllegalArgumentException("Time interval is not supported");
    }

    private static Rounding.Prepared createRounding(Period period, ZoneId timeZone) {
        Rounding.Builder rounding;
        if (period == null || period.isNegative() || period.isZero()) {
            throw new IllegalArgumentException("Zero or negative time interval is not supported");
        }
        long periods = period.getUnits().stream().filter(unit -> period.get((TemporalUnit)unit) != 0L).count();
        if (periods != 1L) {
            throw new IllegalArgumentException("Time interval with multiple periods is not supported");
        }
        if (period.getDays() == 1) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.DAY_OF_MONTH);
        } else if (period.getDays() == 7) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR);
        } else if (period.getDays() > 1) {
            rounding = new Rounding.Builder(new TimeValue((long)period.getDays(), TimeUnit.DAYS));
        } else if (period.getMonths() == 1) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.MONTH_OF_YEAR);
        } else if (period.getMonths() == 3) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.QUARTER_OF_YEAR);
        } else if (period.getYears() == 1) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.YEAR_OF_CENTURY);
        } else {
            throw new IllegalArgumentException("Time interval is not supported");
        }
        rounding.timeZone(timeZone);
        return rounding.build().prepareForUnknown();
    }

    private static Rounding.Prepared createRounding(Duration duration, ZoneId timeZone) {
        if (duration == null || duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("Zero or negative time interval is not supported");
        }
        Rounding.Builder rounding = new Rounding.Builder(TimeValue.timeValueMillis((long)duration.toMillis()));
        rounding.timeZone(timeZone);
        return rounding.build().prepareForUnknown();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        Object foldedInterval;
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.timestampField);
        if (!this.interval.foldable()) {
            throw new IllegalArgumentException("Function [" + this.sourceText() + "] has invalid interval [" + this.interval.sourceText() + "].");
        }
        try {
            foldedInterval = this.interval.fold();
            if (foldedInterval == null) {
                throw new IllegalArgumentException("Interval cannot not be null");
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Function [" + this.sourceText() + "] has invalid interval [" + this.interval.sourceText() + "]. " + e.getMessage());
        }
        return DateTrunc.evaluator(this.source(), fieldEvaluator, DateTrunc.createRounding(foldedInterval, DEFAULT_TZ));
    }

    public static EvalOperator.ExpressionEvaluator.Factory evaluator(Source source, EvalOperator.ExpressionEvaluator.Factory fieldEvaluator, Rounding.Prepared rounding) {
        return new DateTruncEvaluator.Factory(source, fieldEvaluator, rounding);
    }
}

