/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromStringEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToUnsignedLong
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToUnsignedLong", ToUnsignedLong::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.UNSIGNED_LONG, (fieldEval, source) -> fieldEval), Map.entry(DataType.DATETIME, ToUnsignedLongFromLongEvaluator.Factory::new), Map.entry(DataType.BOOLEAN, ToUnsignedLongFromBooleanEvaluator.Factory::new), Map.entry(DataType.KEYWORD, ToUnsignedLongFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToUnsignedLongFromStringEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToUnsignedLongFromDoubleEvaluator.Factory::new), Map.entry(DataType.LONG, ToUnsignedLongFromLongEvaluator.Factory::new), Map.entry(DataType.INTEGER, ToUnsignedLongFromIntEvaluator.Factory::new));

    @FunctionInfo(returnType={"unsigned_long"}, description="Converts an input value to an unsigned long value. If the input parameter is of a date type,\nits value will be interpreted as milliseconds since the {wikipedia}/Unix_time[Unix epoch], converted to unsigned long.\nBoolean *true* will be converted to unsigned long *1*, *false* to *0*.", examples={@Example(file="ints", tag="to_unsigned_long-str", explanation="Note that in this example, the last conversion of the string isn't possible.\nWhen this happens, the result is a *null* value. In this case a _Warning_ header is added to the response.\nThe header will provide information on the source of the failure:\n\n`\"Line 1:133: evaluation of [TO_UL(str3)] failed, treating result as null. Only first 20 failures recorded.\"`\n\nA following header will contain the failure reason and the offending value:\n\n`\"java.lang.NumberFormatException: Character f is neither a decimal digit number, decimal point,\n+ \"nor \"e\" notation exponential mark.\"`")})
    public ToUnsignedLong(Source source, @Param(name="field", type={"boolean", "date", "keyword", "text", "double", "long", "unsigned_long", "integer"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToUnsignedLong(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToUnsignedLong.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.UNSIGNED_LONG;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToUnsignedLong(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToUnsignedLong::new, (Object)this.field());
    }

    static long fromBoolean(boolean bool) {
        return EsqlDataTypeConverter.booleanToUnsignedLong(bool);
    }

    static long fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToUnsignedLong(in.utf8ToString());
    }

    static long fromDouble(double dbl) {
        return EsqlDataTypeConverter.doubleToUnsignedLong(dbl);
    }

    static long fromLong(long lng) {
        return EsqlDataTypeConverter.longToUnsignedLong(lng, false);
    }

    static long fromInt(int i) {
        return EsqlDataTypeConverter.intToUnsignedLong(i);
    }
}

