/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;

public final class ToIntegerFromDoubleEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToIntegerFromDoubleEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToIntegerFromDouble";
    }

    @Override
    public Block evalVector(Vector v) {
        DoubleVector vector = (DoubleVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantIntBlockWith(ToIntegerFromDoubleEvaluator.evalValue(vector, 0), positionCount);
            }
            catch (InvalidArgumentException e) {
                this.registerException((Exception)((Object)e));
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendInt(ToIntegerFromDoubleEvaluator.evalValue(vector, p));
                    continue;
                }
                catch (InvalidArgumentException e) {
                    this.registerException((Exception)((Object)e));
                    builder.appendNull();
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private static int evalValue(DoubleVector container, int index) {
        double value = container.getDouble(index);
        return ToInteger.fromDouble(value);
    }

    @Override
    public Block evalBlock(Block b) {
        DoubleBlock block = (DoubleBlock)b;
        int positionCount = block.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        int value = ToIntegerFromDoubleEvaluator.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendInt(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (InvalidArgumentException e) {
                        this.registerException((Exception)((Object)e));
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private static int evalValue(DoubleBlock container, int index) {
        double value = container.getDouble(index);
        return ToInteger.fromDouble(value);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field, Source source) {
            this.field = field;
            this.source = source;
        }

        public ToIntegerFromDoubleEvaluator get(DriverContext context) {
            return new ToIntegerFromDoubleEvaluator(this.field.get(context), this.source, context);
        }

        public String toString() {
            return "ToIntegerFromDoubleEvaluator[field=" + this.field + "]";
        }
    }
}

