/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import joptsimple.internal.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public abstract class AbstractConvertFunction
extends UnaryScalarFunction {
    private static final List<DataType> NUMERIC_TYPES = List.of(DataType.INTEGER, DataType.LONG, DataType.UNSIGNED_LONG, DataType.DOUBLE);

    protected AbstractConvertFunction(Source source, Expression field) {
        super(source, field);
    }

    protected AbstractConvertFunction(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class));
    }

    protected final EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        DataType sourceType = this.field().dataType().widenSmallNumeric();
        BuildFactory factory = this.factories().get(sourceType);
        if (factory == null) {
            throw EsqlIllegalArgumentException.illegalDataType(sourceType);
        }
        return factory.build(fieldEval, this.source());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isTypeOrUnionType((Expression)this.field(), this.factories()::containsKey, (String)this.sourceText(), null, (String[])new String[]{AbstractConvertFunction.supportedTypesNames(this.supportedTypes())});
    }

    public Set<DataType> supportedTypes() {
        return this.factories().keySet();
    }

    private static String supportedTypesNames(Set<DataType> types) {
        ArrayList<String> supportedTypesNames = new ArrayList<String>(types.size());
        HashSet<DataType> supportTypes = new HashSet<DataType>(types);
        if (supportTypes.containsAll(NUMERIC_TYPES)) {
            supportedTypesNames.add("numeric");
            NUMERIC_TYPES.forEach(supportTypes::remove);
        }
        if (types.containsAll(DataType.stringTypes())) {
            supportedTypesNames.add("string");
            DataType.stringTypes().forEach(supportTypes::remove);
        }
        supportTypes.forEach(t -> supportedTypesNames.add(t.nameUpper().toLowerCase(Locale.ROOT)));
        supportedTypesNames.sort(String::compareTo);
        return Strings.join(supportedTypesNames, (String)" or ");
    }

    protected abstract Map<DataType, BuildFactory> factories();

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return this.evaluator(toEvaluator.apply(this.field()));
    }

    @FunctionalInterface
    static interface BuildFactory {
        public EvalOperator.ExpressionEvaluator.Factory build(EvalOperator.ExpressionEvaluator.Factory var1, Source var2);
    }

    public static abstract class AbstractEvaluator
    implements EvalOperator.ExpressionEvaluator {
        private static final Log logger = LogFactory.getLog(AbstractEvaluator.class);
        protected final DriverContext driverContext;
        private final EvalOperator.ExpressionEvaluator fieldEvaluator;
        private final Warnings warnings;

        protected AbstractEvaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field, Source source) {
            this.driverContext = driverContext;
            this.fieldEvaluator = field;
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)driverContext.warningsMode(), (int)source.source().getLineNumber(), (int)source.source().getColumnNumber(), (String)source.text());
        }

        protected abstract String name();

        protected abstract Block evalBlock(Block var1);

        protected abstract Block evalVector(Vector var1);

        public final Block eval(Page page) {
            try (Block block = this.fieldEvaluator.eval(page);){
                Vector vector = block.asVector();
                Block block2 = vector == null ? this.evalBlock(block) : this.evalVector(vector);
                return block2;
            }
        }

        protected final void registerException(Exception exception) {
            logger.trace((Object)"conversion failure", (Throwable)exception);
            this.warnings.registerException(exception);
        }

        public final String toString() {
            return this.name() + "Evaluator[field=" + this.fieldEvaluator + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.fieldEvaluator);
        }
    }
}

