/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Greatest
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Greatest", Greatest::new);
    private DataType dataType;

    @FunctionInfo(returnType={"boolean", "date", "double", "integer", "ip", "keyword", "long", "text", "version"}, description="Returns the maximum value from multiple columns. This is similar to <<esql-mv_max>>\nexcept it is intended to run on multiple columns at once.", note="When run on `keyword` or `text` fields, this returns the last string in alphabetical order. When run on `boolean` columns this will return `true` if any values are `true`.", examples={@Example(file="math", tag="greatest")})
    public Greatest(Source source, @Param(name="first", type={"boolean", "date", "double", "integer", "ip", "keyword", "long", "text", "version"}, description="First of the columns to evaluate.") Expression first, @Param(name="rest", type={"boolean", "date", "double", "integer", "ip", "keyword", "long", "text", "version"}, description="The rest of the columns to evaluate.", optional=true) List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    private Greatest(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteableCollection(this.children().subList(1, this.children().size()));
    }

    public String getWriteableName() {
        return Greatest.ENTRY.name;
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        for (int position = 0; position < this.children().size(); ++position) {
            Expression child = (Expression)this.children().get(position);
            if (this.dataType == null || this.dataType == DataType.NULL) {
                this.dataType = child.dataType();
                continue;
            }
            Expression.TypeResolution resolution = TypeResolutions.isType((Expression)child, t -> t == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Greatest(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Greatest::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        DataType dataType = this.dataType();
        EvalOperator.ExpressionEvaluator.Factory[] factories = (EvalOperator.ExpressionEvaluator.Factory[])this.children().stream().map(e -> toEvaluator.apply((Expression)new MvMax(e.source(), (Expression)e))).toArray(EvalOperator.ExpressionEvaluator.Factory[]::new);
        if (dataType == DataType.BOOLEAN) {
            return new GreatestBooleanEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataType.DOUBLE) {
            return new GreatestDoubleEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataType.INTEGER) {
            return new GreatestIntEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataType.LONG || dataType == DataType.DATETIME) {
            return new GreatestLongEvaluator.Factory(this.source(), factories);
        }
        if (DataType.isString((DataType)dataType) || dataType == DataType.IP || dataType == DataType.VERSION || dataType == DataType.UNSUPPORTED) {
            return new GreatestBytesRefEvaluator.Factory(this.source(), factories);
        }
        throw EsqlIllegalArgumentException.illegalDataType(dataType);
    }

    static boolean process(boolean[] values) {
        for (boolean v : values) {
            if (!v) continue;
            return true;
        }
        return false;
    }

    static BytesRef process(BytesRef[] values) {
        BytesRef max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = max.compareTo(values[i]) > 0 ? max : values[i];
        }
        return max;
    }

    static int process(int[] values) {
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    static long process(long[] values) {
        long max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    static double process(double[] values) {
        double max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }
}

