/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public final class Case
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Case", Case::new);
    private final List<Condition> conditions;
    private final Expression elseValue;
    private DataType dataType;

    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Accepts pairs of conditions and values. The function returns the value that\nbelongs to the first condition that evaluates to `true`.\n\nIf the number of arguments is odd, the last argument is the default value which\nis returned when no condition matches. If the number of arguments is even, and\nno condition matches, the function returns `null`.", examples={@Example(description="Determine whether employees are monolingual, bilingual, or polyglot:", file="docs", tag="case"), @Example(description="Calculate the total connection success rate based on log messages:", file="conditional", tag="docsCaseSuccessRate"), @Example(description="Calculate an hourly error rate as a percentage of the total number of log messages:", file="conditional", tag="docsCaseHourlyErrorRate")})
    public Case(Source source, @Param(name="condition", type={"boolean"}, description="A condition.") Expression first, @Param(name="trueValue", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="The value that's returned when the corresponding condition is the first to evaluate to `true`. The default value is returned when no condition matches.") List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
        int conditionCount = this.children().size() / 2;
        this.conditions = new ArrayList<Condition>(conditionCount);
        for (int c = 0; c < conditionCount; ++c) {
            this.conditions.add(new Condition((Expression)this.children().get(c * 2), (Expression)this.children().get(c * 2 + 1)));
        }
        this.elseValue = this.elseValueIsExplicit() ? (Expression)this.children().get(this.children().size() - 1) : new Literal(source, null, DataType.NULL);
    }

    private Case(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteableCollection(this.children().subList(1, this.children().size()));
    }

    public String getWriteableName() {
        return Case.ENTRY.name;
    }

    private boolean elseValueIsExplicit() {
        return this.children().size() % 2 == 1;
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        if (this.children().size() < 2) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"expected at least two arguments in [{}] but got {}", (Object[])new Object[]{this.sourceText(), this.children().size()}));
        }
        for (int c = 0; c < this.conditions.size(); ++c) {
            Condition condition = this.conditions.get(c);
            Expression.TypeResolution resolution = TypeResolutions.isBoolean((Expression)condition.condition, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)(c * 2)));
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = this.resolveValueType(condition.value, c * 2 + 1);
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return this.resolveValueType(this.elseValue, this.conditions.size() * 2);
    }

    private Expression.TypeResolution resolveValueType(Expression value, int position) {
        if (this.dataType == null || this.dataType == DataType.NULL) {
            this.dataType = value.dataType();
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return TypeResolutions.isType((Expression)value, t -> t == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
    }

    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Case(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Case::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        for (Condition condition : this.conditions) {
            if (!condition.condition.foldable()) {
                return false;
            }
            if (!Boolean.TRUE.equals(condition.condition.fold())) continue;
            return condition.value.foldable();
        }
        return this.elseValue.foldable();
    }

    public Expression partiallyFold() {
        ArrayList<Expression> newChildren = new ArrayList<Expression>(this.children().size());
        boolean modified = false;
        for (Condition condition : this.conditions) {
            if (!condition.condition.foldable()) {
                newChildren.add(condition.condition);
                newChildren.add(condition.value);
                continue;
            }
            modified = true;
            if (!Boolean.TRUE.equals(condition.condition.fold())) continue;
            newChildren.add(condition.value);
            return this.finishPartialFold(newChildren);
        }
        if (!modified) {
            return this;
        }
        if (this.elseValueIsExplicit()) {
            newChildren.add(this.elseValue);
        }
        return this.finishPartialFold(newChildren);
    }

    private Expression finishPartialFold(List<Expression> newChildren) {
        return switch (newChildren.size()) {
            case 0 -> new Literal(this.source(), null, this.dataType());
            case 1 -> newChildren.get(0);
            default -> this.replaceChildren(newChildren);
        };
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        List<ConditionEvaluatorSupplier> conditionsFactories = this.conditions.stream().map(c -> c.toEvaluator(toEvaluator)).toList();
        EvalOperator.ExpressionEvaluator.Factory elseValueFactory = toEvaluator.apply(this.elseValue);
        ElementType resultType = PlannerUtils.toElementType(this.dataType());
        if (conditionsFactories.size() == 1 && conditionsFactories.get((int)0).value.eagerEvalSafeInLazy() && elseValueFactory.eagerEvalSafeInLazy()) {
            return new CaseEagerEvaluatorFactory(resultType, conditionsFactories.get(0), elseValueFactory);
        }
        return new CaseLazyEvaluatorFactory(resultType, conditionsFactories, elseValueFactory);
    }

    record Condition(Expression condition, Expression value) {
        ConditionEvaluatorSupplier toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
            return new ConditionEvaluatorSupplier(this.condition.source(), toEvaluator.apply(this.condition), toEvaluator.apply(this.value));
        }
    }

    record ConditionEvaluatorSupplier(Source conditionSource, EvalOperator.ExpressionEvaluator.Factory condition, EvalOperator.ExpressionEvaluator.Factory value) implements Function<DriverContext, ConditionEvaluator>
    {
        @Override
        public ConditionEvaluator apply(DriverContext driverContext) {
            return new ConditionEvaluator(Warnings.createWarningsTreatedAsFalse((DriverContext.WarningsMode)driverContext.warningsMode(), (int)this.conditionSource.source().getLineNumber(), (int)this.conditionSource.source().getColumnNumber(), (String)this.conditionSource.text()), this.condition.get(driverContext), this.value.get(driverContext));
        }

        @Override
        public String toString() {
            return "ConditionEvaluator[condition=" + this.condition + ", value=" + this.value + "]";
        }
    }

    private record CaseEagerEvaluatorFactory(ElementType resultType, ConditionEvaluatorSupplier conditionFactory, EvalOperator.ExpressionEvaluator.Factory elseValueFactory) implements EvalOperator.ExpressionEvaluator.Factory
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            CaseEagerEvaluator caseEagerEvaluator;
            ConditionEvaluator conditionEvaluator = this.conditionFactory.apply(context);
            EvalOperator.ExpressionEvaluator elseValue = null;
            try {
                elseValue = this.elseValueFactory.get(context);
                CaseEagerEvaluator result = new CaseEagerEvaluator(this.resultType, context.blockFactory(), conditionEvaluator, elseValue);
                conditionEvaluator = null;
                elseValue = null;
                caseEagerEvaluator = result;
            }
            catch (Throwable throwable) {
                Releasables.close((Releasable[])new Releasable[]{conditionEvaluator, elseValue});
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{conditionEvaluator, elseValue});
            return caseEagerEvaluator;
        }

        @Override
        public String toString() {
            return "CaseEagerEvaluator[conditions=[" + this.conditionFactory + "], elseVal=" + this.elseValueFactory + "]";
        }
    }

    private record CaseLazyEvaluatorFactory(ElementType resultType, List<ConditionEvaluatorSupplier> conditionsFactories, EvalOperator.ExpressionEvaluator.Factory elseValueFactory) implements EvalOperator.ExpressionEvaluator.Factory
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            CaseLazyEvaluator caseLazyEvaluator;
            ArrayList<ConditionEvaluator> conditions = new ArrayList<ConditionEvaluator>(this.conditionsFactories.size());
            EvalOperator.ExpressionEvaluator elseValue = null;
            try {
                for (ConditionEvaluatorSupplier cond : this.conditionsFactories) {
                    conditions.add(cond.apply(context));
                }
                elseValue = this.elseValueFactory.get(context);
                CaseLazyEvaluator result = new CaseLazyEvaluator(context.blockFactory(), this.resultType, conditions, elseValue);
                conditions = null;
                elseValue = null;
                caseLazyEvaluator = result;
            }
            catch (Throwable throwable) {
                Releasables.close((Releasable[])new Releasable[]{conditions == null ? () -> {} : Releasables.wrap(conditions), elseValue});
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{conditions == null ? () -> {} : Releasables.wrap(conditions), elseValue});
            return caseLazyEvaluator;
        }

        @Override
        public String toString() {
            return "CaseLazyEvaluator[conditions=" + this.conditionsFactories + ", elseVal=" + this.elseValueFactory + "]";
        }
    }

    private record CaseEagerEvaluator(ElementType resultType, BlockFactory blockFactory, ConditionEvaluator condition, EvalOperator.ExpressionEvaluator elseVal) implements EvalOperator.ExpressionEvaluator
    {
        /*
         * Exception decompiling
         */
        public Block eval(Page page) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 40[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.condition, this.elseVal});
        }

        @Override
        public String toString() {
            return "CaseEagerEvaluator[conditions=[" + this.condition + "], elseVal=" + this.elseVal + "]";
        }
    }

    private record CaseLazyEvaluator(BlockFactory blockFactory, ElementType resultType, List<ConditionEvaluator> conditions, EvalOperator.ExpressionEvaluator elseVal) implements EvalOperator.ExpressionEvaluator
    {
        /*
         * Unable to fully structure code
         */
        public Block eval(Page page) {
            positionCount = page.getPositionCount();
            result = this.resultType.newBlockBuilder(positionCount, this.blockFactory);
lbl3:
            // 3 sources

            try {
                for (p = 0; p < positionCount; ++p) {
                    positions = new int[]{p};
                    limited = new Page(1, (Block[])IntStream.range(0, page.getBlockCount()).mapToObj((IntFunction<Block>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$eval$0(org.elasticsearch.compute.data.Page int[] int ), (I)Lorg/elasticsearch/compute/data/Block;)((Page)page, (int[])positions)).toArray((IntFunction<Block[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$eval$1(int ), (I)[Lorg/elasticsearch/compute/data/Block;)()));
                    ignored = (Releasable)LambdaMetafactory.metafactory(null, null, null, ()V, releaseBlocks(), ()V)((Page)limited);
                    for (ConditionEvaluator condition : this.conditions) {
                        b = (BooleanBlock)condition.condition.eval(limited);
                        try {
                            if (b.isNull(0)) continue;
                            if (b.getValueCount(0) > 1) {
                                condition.registerMultivalue();
                                continue;
                            }
                            if (!b.getBoolean(b.getFirstValueIndex(0))) continue;
                            values = condition.value.eval(limited);
                            try {
                                result.copyFrom(values, 0, 1);
                                if (values == null) ** GOTO lbl3
                            }
                            catch (Throwable var12_20) {
                                if (values != null) {
                                    try {
                                        values.close();
                                    }
                                    catch (Throwable var13_22) {
                                        var12_20.addSuppressed(var13_22);
                                    }
                                }
                                throw var12_20;
                            }
                            values.close();
                            ** GOTO lbl3
                        }
                        finally {
                            if (b == null) continue;
                            b.close();
                        }
                    }
                    values = this.elseVal.eval(limited);
                    try {
                        result.copyFrom(values, 0, 1);
                        continue;
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                var4_5 = result.build();
                return var4_5;
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> Releasables.close(this.conditions), this.elseVal});
        }

        @Override
        public String toString() {
            return "CaseLazyEvaluator[conditions=" + this.conditions + ", elseVal=" + this.elseVal + "]";
        }

        private static /* synthetic */ Block[] lambda$eval$1(int x$0) {
            return new Block[x$0];
        }

        private static /* synthetic */ Block lambda$eval$0(Page page, int[] positions, int b) {
            return page.getBlock(b).filter(positions);
        }
    }

    record ConditionEvaluator(Warnings conditionWarnings, EvalOperator.ExpressionEvaluator condition, EvalOperator.ExpressionEvaluator value) implements Releasable
    {
        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.condition, this.value});
        }

        @Override
        public String toString() {
            return "ConditionEvaluator[condition=" + this.condition + ", value=" + this.value + "]";
        }

        public void registerMultivalue() {
            this.conditionWarnings.registerException((Exception)new IllegalArgumentException("CASE expects a single-valued boolean"));
        }
    }
}

