/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.grouping;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.grouping.Categorize;
import org.elasticsearch.xpack.ml.aggs.categorization.TokenListCategorizer;
import org.elasticsearch.xpack.ml.job.categorization.CategorizationAnalyzer;

public final class CategorizeEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator v;
    private final CategorizationAnalyzer analyzer;
    private final TokenListCategorizer.CloseableTokenListCategorizer categorizer;
    private final DriverContext driverContext;
    private Warnings warnings;

    public CategorizeEvaluator(Source source, EvalOperator.ExpressionEvaluator v, CategorizationAnalyzer analyzer, TokenListCategorizer.CloseableTokenListCategorizer categorizer, DriverContext driverContext) {
        this.source = source;
        this.v = v;
        this.analyzer = analyzer;
        this.categorizer = categorizer;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock vBlock = (BytesRefBlock)this.v.eval(page);){
            BytesRefVector vVector = vBlock.asVector();
            if (vVector == null) {
                IntBlock intBlock = this.eval(page.getPositionCount(), vBlock);
                return intBlock;
            }
            IntBlock intBlock = this.eval(page.getPositionCount(), vVector).asBlock();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, BytesRefBlock vBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef vScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (vBlock.getValueCount(p) != 1) {
                    if (vBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendInt(Categorize.process(vBlock.getBytesRef(vBlock.getFirstValueIndex(p), vScratch), this.analyzer, this.categorizer));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, BytesRefVector vVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            BytesRef vScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendInt(p, Categorize.process(vVector.getBytesRef(p, vScratch), this.analyzer, this.categorizer));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "CategorizeEvaluator[v=" + this.v + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.v, this.analyzer, this.categorizer});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory v;
        private final Function<DriverContext, CategorizationAnalyzer> analyzer;
        private final Function<DriverContext, TokenListCategorizer.CloseableTokenListCategorizer> categorizer;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory v, Function<DriverContext, CategorizationAnalyzer> analyzer, Function<DriverContext, TokenListCategorizer.CloseableTokenListCategorizer> categorizer) {
            this.source = source;
            this.v = v;
            this.analyzer = analyzer;
            this.categorizer = categorizer;
        }

        public CategorizeEvaluator get(DriverContext context) {
            return new CategorizeEvaluator(this.source, this.v.get(context), this.analyzer.apply(context), this.categorizer.apply(context), context);
        }

        public String toString() {
            return "CategorizeEvaluator[v=" + this.v + "]";
        }
    }
}

