/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.Validatable;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Match
extends FullTextFunction
implements Validatable {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Match", Match::new);
    private final Expression field;

    @FunctionInfo(returnType={"boolean"}, preview=true, description="Performs a match query on the specified field. Returns true if the provided query matches the row.", examples={@Example(file="match-function", tag="match-with-field")})
    public Match(Source source, @Param(name="field", type={"keyword", "text"}, description="Field that the query will target.") Expression field, @Param(name="query", type={"keyword", "text"}, description="Text you wish to find in the provided field.") Expression matchQuery) {
        super(source, matchQuery, List.of(field, matchQuery));
        this.field = field;
    }

    private Match(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteable((NamedWriteable)this.query());
    }

    public String getWriteableName() {
        return Match.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveNonQueryParamTypes() {
        return TypeResolutions.isNotNull((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST)).and(super.resolveNonQueryParamTypes());
    }

    @Override
    public void validate(Failures failures) {
        if (!(this.field instanceof FieldAttribute)) {
            failures.add(Failure.fail(this.field, "[{}] cannot operate on [{}], which is not a field from an index mapping", new Object[]{this.functionName(), this.field.sourceText()}));
        }
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Match(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Match::new, (Object)this.field, (Object)this.query());
    }

    @Override
    protected TypeResolutions.ParamOrdinal queryParamOrdinal() {
        return TypeResolutions.ParamOrdinal.SECOND;
    }

    public Expression field() {
        return this.field;
    }
}

