/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.esql.action.EsqlCapabilities;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Match;
import org.elasticsearch.xpack.esql.expression.function.fulltext.QueryString;

public abstract class FullTextFunction
extends Function {
    private final Expression query;

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        if (EsqlCapabilities.Cap.QSTR_FUNCTION.isEnabled()) {
            entries.add(QueryString.ENTRY);
        }
        if (EsqlCapabilities.Cap.MATCH_FUNCTION.isEnabled()) {
            entries.add(Match.ENTRY);
        }
        return entries;
    }

    protected FullTextFunction(Source source, Expression query, List<Expression> children) {
        super(source, children);
        this.query = query;
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    protected final Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return this.resolveNonQueryParamTypes().and(this.resolveQueryParamType());
    }

    private Expression.TypeResolution resolveQueryParamType() {
        return TypeResolutions.isString((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)this.queryParamOrdinal()).and(TypeResolutions.isNotNullAndFoldable((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)this.queryParamOrdinal()));
    }

    protected Expression.TypeResolution resolveNonQueryParamTypes() {
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Expression query() {
        return this.query;
    }

    public final String queryAsText() {
        Object queryAsObject = this.query().fold();
        if (queryAsObject instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)queryAsObject;
            return bytesRef.utf8ToString();
        }
        throw new IllegalArgumentException(LoggerMessageFormat.format(null, (String)"{} argument in {} function needs to be resolved to a string", (Object[])new Object[]{this.queryParamOrdinal(), this.functionName()}));
    }

    protected TypeResolutions.ParamOrdinal queryParamOrdinal() {
        return TypeResolutions.ParamOrdinal.DEFAULT;
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }
}

