/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Values
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Values", Values::new);

    @FunctionInfo(returnType={"boolean", "date", "double", "integer", "ip", "keyword", "long", "text", "version"}, preview=true, description="Returns all values in a group as a multivalued field. The order of the returned values isn't guaranteed. If you need the values returned in order use <<esql-mv_sort>>.", appendix="[WARNING]\n====\nThis can use a significant amount of memory and ES|QL doesn't yet\ngrow aggregations beyond memory. So this aggregation will work until\nit is used to collect more values than can fit into memory. Once it\ncollects too many values it will fail the query with\na <<circuit-breaker-errors, Circuit Breaker Error>>.\n====", isAggregation=true, examples={@Example(file="string", tag="values-grouped")})
    public Values(Source source, @Param(name="field", type={"boolean", "date", "double", "integer", "ip", "keyword", "long", "text", "version"}) Expression v) {
        this(source, v, (Expression)Literal.TRUE);
    }

    public Values(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    private Values(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Values.ENTRY.name;
    }

    protected NodeInfo<Values> info() {
        return NodeInfo.create((Node)this, Values::new, (Object)this.field(), (Object)this.filter());
    }

    public Values replaceChildren(List<Expression> newChildren) {
        return new Values(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    public Values withFilter(Expression filter) {
        return new Values(this.source(), this.field(), filter);
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> !DataType.isSpatial((DataType)dt) && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"any type except unsigned_long and spatial types"});
    }

    @Override
    public AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (type == DataType.INTEGER) {
            return new ValuesIntAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.LONG || type == DataType.DATETIME) {
            return new ValuesLongAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.DOUBLE) {
            return new ValuesDoubleAggregatorFunctionSupplier(inputChannels);
        }
        if (DataType.isString((DataType)type) || type == DataType.IP || type == DataType.VERSION) {
            return new ValuesBytesRefAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.BOOLEAN) {
            return new ValuesBooleanAggregatorFunctionSupplier(inputChannels);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }
}

