/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinIpAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MinLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Min
extends AggregateFunction
implements ToAggregator,
SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Min", Min::new);

    @FunctionInfo(returnType={"boolean", "double", "integer", "long", "date", "ip", "keyword", "text", "long", "version"}, description="The minimum value of a field.", isAggregation=true, examples={@Example(file="stats", tag="min"), @Example(description="The expression can use inline functions. For example, to calculate the minimum over an average of a multivalued column, use `MV_AVG` to first average the multiple values per row, and use the result with the `MIN` function", file="stats", tag="docsStatsMinNestedExpression")})
    public Min(Source source, @Param(name="field", type={"boolean", "double", "integer", "long", "date", "ip", "keyword", "text", "long", "version"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public Min(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    private Min(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Min.ENTRY.name;
    }

    protected NodeInfo<Min> info() {
        return NodeInfo.create((Node)this, Min::new, (Object)this.field(), (Object)this.filter());
    }

    public Min replaceChildren(List<Expression> newChildren) {
        return new Min(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    public Min withFilter(Expression filter) {
        return new Min(this.source(), this.field(), filter);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), t -> DataType.isRepresentable((DataType)t) && t != DataType.UNSIGNED_LONG && !DataType.isSpatial((DataType)t), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"representable except unsigned_long and spatial types"});
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    public final AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (type == DataType.BOOLEAN) {
            return new MinBooleanAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.LONG || type == DataType.DATETIME) {
            return new MinLongAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.INTEGER) {
            return new MinIntAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.DOUBLE) {
            return new MinDoubleAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.IP) {
            return new MinIpAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.VERSION || DataType.isString((DataType)type)) {
            return new MinBytesRefAggregatorFunctionSupplier(inputChannels);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }

    @Override
    public Expression surrogate() {
        return this.field().foldable() ? new MvMin(this.source(), this.field()) : null;
    }
}

