/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxIpAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.MaxLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Max
extends AggregateFunction
implements ToAggregator,
SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Max", Max::new);

    @FunctionInfo(returnType={"boolean", "double", "integer", "long", "date", "ip", "keyword", "text", "long", "version"}, description="The maximum value of a field.", isAggregation=true, examples={@Example(file="stats", tag="max"), @Example(description="The expression can use inline functions. For example, to calculate the maximum over an average of a multivalued column, use `MV_AVG` to first average the multiple values per row, and use the result with the `MAX` function", file="stats", tag="docsStatsMaxNestedExpression")})
    public Max(Source source, @Param(name="field", type={"boolean", "double", "integer", "long", "date", "ip", "keyword", "text", "long", "version"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public Max(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    private Max(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Max.ENTRY.name;
    }

    @Override
    public Max withFilter(Expression filter) {
        return new Max(this.source(), this.field(), filter);
    }

    protected NodeInfo<Max> info() {
        return NodeInfo.create((Node)this, Max::new, (Object)this.field(), (Object)this.filter());
    }

    public Max replaceChildren(List<Expression> newChildren) {
        return new Max(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), t -> DataType.isRepresentable((DataType)t) && t != DataType.UNSIGNED_LONG && !DataType.isSpatial((DataType)t), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"representable except unsigned_long and spatial types"});
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    public final AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (type == DataType.BOOLEAN) {
            return new MaxBooleanAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.LONG || type == DataType.DATETIME) {
            return new MaxLongAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.INTEGER) {
            return new MaxIntAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.DOUBLE) {
            return new MaxDoubleAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.IP) {
            return new MaxIpAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataType.VERSION || DataType.isString((DataType)type)) {
            return new MaxBytesRefAggregatorFunctionSupplier(inputChannels);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }

    @Override
    public Expression surrogate() {
        return this.field().foldable() ? new MvMax(this.source(), this.field()) : null;
    }
}

