/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.Build;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.xpack.esql.core.ParsingException;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.TwoOptionalArguments;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.CountDistinct;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Median;
import org.elasticsearch.xpack.esql.expression.function.aggregate.MedianAbsoluteDeviation;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Rate;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SpatialCentroid;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Top;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.expression.function.aggregate.WeightedAvg;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Match;
import org.elasticsearch.xpack.esql.expression.function.fulltext.QueryString;
import org.elasticsearch.xpack.esql.expression.function.grouping.Bucket;
import org.elasticsearch.xpack.esql.expression.function.grouping.Categorize;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Case;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Greatest;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Least;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FromBase64;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBase64;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBoolean;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToCartesianPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToCartesianShape;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanos;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDatePeriod;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDatetime;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDegrees;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoShape;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIP;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToRadians;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToTimeDuration;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToVersion;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiff;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtract;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormat;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParse;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTrunc;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.Now;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatch;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.IpPrefix;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Abs;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Acos;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Asin;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan2;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cbrt;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Ceil;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cos;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cosh;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.E;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Exp;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Floor;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Hypot;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log10;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Pi;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Pow;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Round;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Signum;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Sin;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Sinh;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Sqrt;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Tan;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Tanh;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Tau;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAppend;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvg;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvConcat;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvCount;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvDedupe;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirst;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLast;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedianAbsoluteDeviation;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPSeriesWeightedSum;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPercentile;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSlice;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSort;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvZip;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContains;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersects;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithin;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistance;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StX;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StY;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Concat;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.EndsWith;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.LTrim;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Left;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Length;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Locate;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.RTrim;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Repeat;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Replace;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Reverse;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Right;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Space;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Split;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.StartsWith;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Substring;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ToLower;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ToUpper;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Trim;
import org.elasticsearch.xpack.esql.session.Configuration;

public class EsqlFunctionRegistry {
    private static final Map<Class<? extends org.elasticsearch.xpack.esql.core.expression.function.Function>, List<DataType>> dataTypesForStringLiteralConversion = new LinkedHashMap<Class<? extends org.elasticsearch.xpack.esql.core.expression.function.Function>, List<DataType>>();
    private static final Map<DataType, Integer> dataTypeCastingPriority;
    private static final String[] NUM_NAMES;
    private final Map<String, FunctionDefinition> defs = new LinkedHashMap<String, FunctionDefinition>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private SnapshotFunctionRegistry snapshotRegistry = null;

    public EsqlFunctionRegistry() {
        this.register(this.functions());
        this.buildDataTypesForStringLiteralConversion(this.functions());
    }

    EsqlFunctionRegistry(FunctionDefinition ... functions) {
        this.register(functions);
    }

    public FunctionDefinition resolveFunction(String functionName) {
        FunctionDefinition def = this.defs.get(functionName);
        if (def == null) {
            throw new QlIllegalArgumentException("Cannot find function {}; this should have been caught during analysis", new Object[]{functionName});
        }
        return def;
    }

    private String normalize(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public String resolveAlias(String alias) {
        String normalized = this.normalize(alias);
        return this.aliases.getOrDefault(normalized, normalized);
    }

    public boolean functionExists(String functionName) {
        return this.defs.containsKey(functionName);
    }

    public Collection<FunctionDefinition> listFunctions() {
        return this.defs.values();
    }

    public Collection<FunctionDefinition> listFunctions(String pattern) {
        Pattern p = Strings.hasText((String)pattern) ? Pattern.compile(this.normalize(pattern)) : null;
        return this.defs.entrySet().stream().filter(e -> p == null || p.matcher((CharSequence)e.getKey()).matches()).map(e -> this.cloneDefinition((String)e.getKey(), (FunctionDefinition)e.getValue())).collect(Collectors.toList());
    }

    private FunctionDefinition[][] functions() {
        return new FunctionDefinition[][]{{EsqlFunctionRegistry.def(Bucket.class, Bucket::new, "bucket", "bin")}, {EsqlFunctionRegistry.def(Avg.class, EsqlFunctionRegistry.uni(Avg::new), "avg"), EsqlFunctionRegistry.def(Count.class, EsqlFunctionRegistry.uni(Count::new), "count"), EsqlFunctionRegistry.def(CountDistinct.class, EsqlFunctionRegistry.bi(CountDistinct::new), "count_distinct"), EsqlFunctionRegistry.def(Max.class, EsqlFunctionRegistry.uni(Max::new), "max"), EsqlFunctionRegistry.def(Median.class, EsqlFunctionRegistry.uni(Median::new), "median"), EsqlFunctionRegistry.def(MedianAbsoluteDeviation.class, EsqlFunctionRegistry.uni(MedianAbsoluteDeviation::new), "median_absolute_deviation"), EsqlFunctionRegistry.def(Min.class, EsqlFunctionRegistry.uni(Min::new), "min"), EsqlFunctionRegistry.def(Percentile.class, EsqlFunctionRegistry.bi(Percentile::new), "percentile"), EsqlFunctionRegistry.def(Sum.class, EsqlFunctionRegistry.uni(Sum::new), "sum"), EsqlFunctionRegistry.def(Top.class, EsqlFunctionRegistry.tri(Top::new), "top"), EsqlFunctionRegistry.def(Values.class, EsqlFunctionRegistry.uni(Values::new), "values"), EsqlFunctionRegistry.def(WeightedAvg.class, EsqlFunctionRegistry.bi(WeightedAvg::new), "weighted_avg")}, {EsqlFunctionRegistry.def(Abs.class, Abs::new, "abs"), EsqlFunctionRegistry.def(Acos.class, Acos::new, "acos"), EsqlFunctionRegistry.def(Asin.class, Asin::new, "asin"), EsqlFunctionRegistry.def(Atan.class, Atan::new, "atan"), EsqlFunctionRegistry.def(Atan2.class, Atan2::new, "atan2"), EsqlFunctionRegistry.def(Cbrt.class, Cbrt::new, "cbrt"), EsqlFunctionRegistry.def(Ceil.class, Ceil::new, "ceil"), EsqlFunctionRegistry.def(Cos.class, Cos::new, "cos"), EsqlFunctionRegistry.def(Cosh.class, Cosh::new, "cosh"), EsqlFunctionRegistry.def(E.class, E::new, "e"), EsqlFunctionRegistry.def(Exp.class, Exp::new, "exp"), EsqlFunctionRegistry.def(Floor.class, Floor::new, "floor"), EsqlFunctionRegistry.def(Greatest.class, Greatest::new, "greatest"), EsqlFunctionRegistry.def(Hypot.class, Hypot::new, "hypot"), EsqlFunctionRegistry.def(Log.class, Log::new, "log"), EsqlFunctionRegistry.def(Log10.class, Log10::new, "log10"), EsqlFunctionRegistry.def(Least.class, Least::new, "least"), EsqlFunctionRegistry.def(Pi.class, Pi::new, "pi"), EsqlFunctionRegistry.def(Pow.class, Pow::new, "pow"), EsqlFunctionRegistry.def(Round.class, Round::new, "round"), EsqlFunctionRegistry.def(Signum.class, Signum::new, "signum"), EsqlFunctionRegistry.def(Sin.class, Sin::new, "sin"), EsqlFunctionRegistry.def(Sinh.class, Sinh::new, "sinh"), EsqlFunctionRegistry.def(Sqrt.class, Sqrt::new, "sqrt"), EsqlFunctionRegistry.def(Tan.class, Tan::new, "tan"), EsqlFunctionRegistry.def(Tanh.class, Tanh::new, "tanh"), EsqlFunctionRegistry.def(Tau.class, Tau::new, "tau")}, {EsqlFunctionRegistry.def(Concat.class, Concat::new, "concat"), EsqlFunctionRegistry.def(EndsWith.class, EndsWith::new, "ends_with"), EsqlFunctionRegistry.def(LTrim.class, LTrim::new, "ltrim"), EsqlFunctionRegistry.def(Left.class, Left::new, "left"), EsqlFunctionRegistry.def(Length.class, Length::new, "length"), EsqlFunctionRegistry.def(Locate.class, Locate::new, "locate"), EsqlFunctionRegistry.def(RTrim.class, RTrim::new, "rtrim"), EsqlFunctionRegistry.def(Repeat.class, Repeat::new, "repeat"), EsqlFunctionRegistry.def(Replace.class, Replace::new, "replace"), EsqlFunctionRegistry.def(Reverse.class, Reverse::new, "reverse"), EsqlFunctionRegistry.def(Right.class, Right::new, "right"), EsqlFunctionRegistry.def(Space.class, Space::new, "space"), EsqlFunctionRegistry.def(StartsWith.class, StartsWith::new, "starts_with"), EsqlFunctionRegistry.def(Substring.class, Substring::new, "substring"), EsqlFunctionRegistry.def(ToLower.class, ToLower::new, "to_lower"), EsqlFunctionRegistry.def(ToUpper.class, ToUpper::new, "to_upper"), EsqlFunctionRegistry.def(Trim.class, Trim::new, "trim")}, {EsqlFunctionRegistry.def(DateDiff.class, DateDiff::new, "date_diff"), EsqlFunctionRegistry.def(DateExtract.class, DateExtract::new, "date_extract"), EsqlFunctionRegistry.def(DateFormat.class, DateFormat::new, "date_format"), EsqlFunctionRegistry.def(DateParse.class, DateParse::new, "date_parse"), EsqlFunctionRegistry.def(DateTrunc.class, DateTrunc::new, "date_trunc"), EsqlFunctionRegistry.def(Now.class, Now::new, "now")}, {EsqlFunctionRegistry.def(SpatialCentroid.class, SpatialCentroid::new, "st_centroid_agg"), EsqlFunctionRegistry.def(SpatialContains.class, SpatialContains::new, "st_contains"), EsqlFunctionRegistry.def(SpatialDisjoint.class, SpatialDisjoint::new, "st_disjoint"), EsqlFunctionRegistry.def(SpatialIntersects.class, SpatialIntersects::new, "st_intersects"), EsqlFunctionRegistry.def(SpatialWithin.class, SpatialWithin::new, "st_within"), EsqlFunctionRegistry.def(StDistance.class, StDistance::new, "st_distance"), EsqlFunctionRegistry.def(StX.class, StX::new, "st_x"), EsqlFunctionRegistry.def(StY.class, StY::new, "st_y")}, {EsqlFunctionRegistry.def(Case.class, Case::new, "case")}, {EsqlFunctionRegistry.def(Coalesce.class, Coalesce::new, "coalesce")}, {EsqlFunctionRegistry.def(CIDRMatch.class, CIDRMatch::new, "cidr_match")}, {EsqlFunctionRegistry.def(IpPrefix.class, IpPrefix::new, "ip_prefix")}, {EsqlFunctionRegistry.def(FromBase64.class, FromBase64::new, "from_base64"), EsqlFunctionRegistry.def(ToBase64.class, ToBase64::new, "to_base64"), EsqlFunctionRegistry.def(ToBoolean.class, ToBoolean::new, "to_boolean", "to_bool"), EsqlFunctionRegistry.def(ToCartesianPoint.class, ToCartesianPoint::new, "to_cartesianpoint"), EsqlFunctionRegistry.def(ToCartesianShape.class, ToCartesianShape::new, "to_cartesianshape"), EsqlFunctionRegistry.def(ToDatePeriod.class, ToDatePeriod::new, "to_dateperiod"), EsqlFunctionRegistry.def(ToDatetime.class, ToDatetime::new, "to_datetime", "to_dt"), EsqlFunctionRegistry.def(ToDateNanos.class, ToDateNanos::new, "to_date_nanos", "to_datenanos"), EsqlFunctionRegistry.def(ToDegrees.class, ToDegrees::new, "to_degrees"), EsqlFunctionRegistry.def(ToDouble.class, ToDouble::new, "to_double", "to_dbl"), EsqlFunctionRegistry.def(ToGeoPoint.class, ToGeoPoint::new, "to_geopoint"), EsqlFunctionRegistry.def(ToGeoShape.class, ToGeoShape::new, "to_geoshape"), EsqlFunctionRegistry.def(ToIP.class, ToIP::new, "to_ip"), EsqlFunctionRegistry.def(ToInteger.class, ToInteger::new, "to_integer", "to_int"), EsqlFunctionRegistry.def(ToLong.class, ToLong::new, "to_long"), EsqlFunctionRegistry.def(ToRadians.class, ToRadians::new, "to_radians"), EsqlFunctionRegistry.def(ToString.class, ToString::new, "to_string", "to_str"), EsqlFunctionRegistry.def(ToTimeDuration.class, ToTimeDuration::new, "to_timeduration"), EsqlFunctionRegistry.def(ToUnsignedLong.class, ToUnsignedLong::new, "to_unsigned_long", "to_ulong", "to_ul"), EsqlFunctionRegistry.def(ToVersion.class, ToVersion::new, "to_version", "to_ver")}, {EsqlFunctionRegistry.def(MvAppend.class, MvAppend::new, "mv_append"), EsqlFunctionRegistry.def(MvAvg.class, MvAvg::new, "mv_avg"), EsqlFunctionRegistry.def(MvConcat.class, MvConcat::new, "mv_concat"), EsqlFunctionRegistry.def(MvCount.class, MvCount::new, "mv_count"), EsqlFunctionRegistry.def(MvDedupe.class, MvDedupe::new, "mv_dedupe"), EsqlFunctionRegistry.def(MvFirst.class, MvFirst::new, "mv_first"), EsqlFunctionRegistry.def(MvLast.class, MvLast::new, "mv_last"), EsqlFunctionRegistry.def(MvMax.class, MvMax::new, "mv_max"), EsqlFunctionRegistry.def(MvMedian.class, MvMedian::new, "mv_median"), EsqlFunctionRegistry.def(MvMedianAbsoluteDeviation.class, MvMedianAbsoluteDeviation::new, "mv_median_absolute_deviation"), EsqlFunctionRegistry.def(MvMin.class, MvMin::new, "mv_min"), EsqlFunctionRegistry.def(MvPercentile.class, MvPercentile::new, "mv_percentile"), EsqlFunctionRegistry.def(MvPSeriesWeightedSum.class, MvPSeriesWeightedSum::new, "mv_pseries_weighted_sum"), EsqlFunctionRegistry.def(MvSort.class, MvSort::new, "mv_sort"), EsqlFunctionRegistry.def(MvSlice.class, MvSlice::new, "mv_slice"), EsqlFunctionRegistry.def(MvZip.class, MvZip::new, "mv_zip"), EsqlFunctionRegistry.def(MvSum.class, MvSum::new, "mv_sum"), EsqlFunctionRegistry.def(Split.class, Split::new, "split")}};
    }

    private static FunctionDefinition[][] snapshotFunctions() {
        return new FunctionDefinition[][]{{EsqlFunctionRegistry.def(Rate.class, Rate::withUnresolvedTimestamp, "rate"), EsqlFunctionRegistry.def(Categorize.class, Categorize::new, "categorize"), EsqlFunctionRegistry.def(QueryString.class, QueryString::new, "qstr"), EsqlFunctionRegistry.def(Match.class, Match::new, "match")}};
    }

    public EsqlFunctionRegistry snapshotRegistry() {
        if (!Build.current().isSnapshot()) {
            return this;
        }
        SnapshotFunctionRegistry snapshotRegistry = this.snapshotRegistry;
        if (snapshotRegistry == null) {
            this.snapshotRegistry = snapshotRegistry = new SnapshotFunctionRegistry();
        }
        return snapshotRegistry;
    }

    public static boolean isSnapshotOnly(String functionName) {
        FunctionDefinition[][] functionDefinitionArray = EsqlFunctionRegistry.snapshotFunctions();
        int n = functionDefinitionArray.length;
        for (int i = 0; i < n; ++i) {
            FunctionDefinition[] defs;
            for (FunctionDefinition def : defs = functionDefinitionArray[i]) {
                if (!def.name().equalsIgnoreCase(functionName)) continue;
                return true;
            }
        }
        return false;
    }

    public static String normalizeName(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public static DataType getTargetType(String[] names) {
        ArrayList<DataType> types = new ArrayList<DataType>();
        for (String name : names) {
            types.add(DataType.fromEs((String)name));
        }
        if (types.contains(DataType.KEYWORD) || types.contains(DataType.TEXT)) {
            return DataType.UNSUPPORTED;
        }
        return types.stream().min((dt1, dt2) -> dataTypeCastingPriority.get(dt1).compareTo(dataTypeCastingPriority.get(dt2))).orElse(DataType.UNSUPPORTED);
    }

    public static FunctionDescription description(FunctionDefinition def) {
        String[] stringArray;
        String functionDescription;
        Constructor<?> constructor = EsqlFunctionRegistry.constructorFor(def.clazz());
        if (constructor == null) {
            return new FunctionDescription(def.name(), List.of(), null, null, false, false);
        }
        FunctionInfo functionInfo = EsqlFunctionRegistry.functionInfo(def);
        String string = functionDescription = functionInfo == null ? "" : functionInfo.description().replace('\n', ' ');
        if (functionInfo == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "?";
        } else {
            stringArray = EsqlFunctionRegistry.removeUnderConstruction(functionInfo.returnType());
        }
        String[] returnType = stringArray;
        Parameter[] params = constructor.getParameters();
        ArrayList<ArgSignature> args = new ArrayList<ArgSignature>(params.length);
        boolean variadic = false;
        boolean isAggregation = functionInfo == null ? false : functionInfo.isAggregation();
        for (int i = 1; i < params.length; ++i) {
            String[] stringArray3;
            if (Configuration.class.isAssignableFrom(params[i].getType())) continue;
            Param paramInfo = params[i].getAnnotation(Param.class);
            String name = paramInfo == null ? params[i].getName() : paramInfo.name();
            variadic |= List.class.isAssignableFrom(params[i].getType());
            if (paramInfo == null) {
                String[] stringArray4 = new String[1];
                stringArray3 = stringArray4;
                stringArray4[0] = "?";
            } else {
                stringArray3 = EsqlFunctionRegistry.removeUnderConstruction(paramInfo.type());
            }
            String[] type = stringArray3;
            String desc = paramInfo == null ? "" : paramInfo.description().replace('\n', ' ');
            boolean optional = paramInfo == null ? false : paramInfo.optional();
            DataType targetDataType = EsqlFunctionRegistry.getTargetType(type);
            args.add(new ArgSignature(name, type, desc, optional, targetDataType));
        }
        return new FunctionDescription(def.name(), args, returnType, functionDescription, variadic, isAggregation);
    }

    private static String[] removeUnderConstruction(String[] types) {
        for (Map.Entry underConstruction : DataType.UNDER_CONSTRUCTION.entrySet()) {
            if (((FeatureFlag)underConstruction.getValue()).isEnabled()) continue;
            types = (String[])Arrays.stream(types).filter(t -> !((DataType)underConstruction.getKey()).typeName().equals(t)).toArray(String[]::new);
        }
        return types;
    }

    public static FunctionInfo functionInfo(FunctionDefinition def) {
        Constructor<?> constructor = EsqlFunctionRegistry.constructorFor(def.clazz());
        if (constructor == null) {
            return null;
        }
        return constructor.getAnnotation(FunctionInfo.class);
    }

    private static Constructor<?> constructorFor(Class<? extends org.elasticsearch.xpack.esql.core.expression.function.Function> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        if (constructors.length > 1) {
            for (Constructor<?> constructor : constructors) {
                if (constructor.getAnnotation(FunctionInfo.class) == null) continue;
                return constructor;
            }
        }
        return constructors[0];
    }

    private void buildDataTypesForStringLiteralConversion(FunctionDefinition[] ... groupFunctions) {
        FunctionDefinition[][] functionDefinitionArray = groupFunctions;
        int n = functionDefinitionArray.length;
        for (int i = 0; i < n; ++i) {
            FunctionDefinition[] group;
            for (FunctionDefinition def : group = functionDefinitionArray[i]) {
                FunctionDescription signature = EsqlFunctionRegistry.description(def);
                dataTypesForStringLiteralConversion.put(def.clazz(), signature.args().stream().map(ArgSignature::targetDataType).collect(Collectors.toList()));
            }
        }
    }

    public List<DataType> getDataTypeForStringLiteralConversion(Class<? extends org.elasticsearch.xpack.esql.core.expression.function.Function> clazz) {
        return dataTypesForStringLiteralConversion.get(clazz);
    }

    void register(FunctionDefinition[] ... groupFunctions) {
        for (FunctionDefinition[] group : groupFunctions) {
            this.register(group);
        }
    }

    void register(FunctionDefinition ... functions) {
        HashMap<String, FunctionDefinition> batchMap = new HashMap<String, FunctionDefinition>();
        for (FunctionDefinition f : functions) {
            batchMap.put(f.name(), f);
            for (String alias : f.aliases()) {
                FunctionDefinition old = batchMap.put(alias, f);
                if (old != null || this.defs.containsKey(alias)) {
                    throw new QlIllegalArgumentException("alias [" + alias + "] is used by [" + (old != null ? old : this.defs.get(alias).name()) + "] and [" + f.name() + "]");
                }
                this.aliases.put(alias, f.name());
            }
        }
        this.defs.putAll(batchMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new)));
    }

    protected FunctionDefinition cloneDefinition(String name, FunctionDefinition definition) {
        return new FunctionDefinition(name, Collections.emptyList(), definition.clazz(), definition.builder());
    }

    protected static FunctionDefinition def(Class<? extends org.elasticsearch.xpack.esql.core.expression.function.Function> function, FunctionBuilder builder, String ... names) {
        Check.isTrue((names.length > 0 ? 1 : 0) != 0, (String)"At least one name must be provided for the function");
        String primaryName = names[0];
        List<String> aliases = Arrays.asList(names).subList(1, names.length);
        FunctionDefinition.Builder realBuilder = (uf, cfg, extras) -> {
            if (!CollectionUtils.isEmpty((Object[])extras)) {
                throw new ParsingException(uf.source(), "Unused parameters {} detected when building [{}]", new Object[]{Arrays.toString(extras), primaryName});
            }
            try {
                return builder.build(uf.source(), uf.children(), cfg);
            }
            catch (QlIllegalArgumentException e) {
                throw new ParsingException((Exception)((Object)e), uf.source(), "error building [{}]: {}", new Object[]{primaryName, e.getMessage()});
            }
        };
        return new FunctionDefinition(primaryName, Collections.unmodifiableList(aliases), function, realBuilder);
    }

    public static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, Function<Source, T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (!children.isEmpty()) {
                throw new QlIllegalArgumentException("expects no arguments");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.apply(source);
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    public static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, BiFunction<Source, Expression, T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (children.size() != 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.apply(source, (Expression)children.get(0));
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    protected <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, NaryBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, children);
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    public static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, BinaryBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean isBinaryOptionalParamFunction = OptionalArgument.class.isAssignableFrom(function);
            if (isBinaryOptionalParamFunction && (children.size() > 2 || children.size() < 1)) {
                throw new QlIllegalArgumentException("expects one or two arguments");
            }
            if (!isBinaryOptionalParamFunction && children.size() != 2) {
                throw new QlIllegalArgumentException("expects exactly two arguments");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, (Expression)children.get(0), children.size() == 2 ? (Expression)children.get(1) : null);
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    protected static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, TernaryBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean hasMinimumTwo = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumTwo && (children.size() > 3 || children.size() < 2)) {
                throw new QlIllegalArgumentException("expects two or three arguments");
            }
            if (!hasMinimumTwo && children.size() != 3) {
                throw new QlIllegalArgumentException("expects exactly three arguments");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() == 3 ? (Expression)children.get(2) : null);
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    protected static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, QuaternaryBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (OptionalArgument.class.isAssignableFrom(function)) {
                if (children.size() > 4 || children.size() < 3) {
                    throw new QlIllegalArgumentException("expects three or four arguments");
                }
            } else if (TwoOptionalArguments.class.isAssignableFrom(function)) {
                if (children.size() > 4 || children.size() < 2) {
                    throw new QlIllegalArgumentException("expects minimum two, maximum four arguments");
                }
            } else if (children.size() != 4) {
                throw new QlIllegalArgumentException("expects exactly four arguments");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() > 2 ? (Expression)children.get(2) : null, children.size() > 3 ? (Expression)children.get(3) : null);
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    protected static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, QuinaryBuilder<T> ctorRef, int numOptionalParams, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            int NUM_TOTAL_PARAMS = 5;
            boolean hasOptionalParams = OptionalArgument.class.isAssignableFrom(function);
            if (hasOptionalParams && (children.size() > 5 || children.size() < 5 - numOptionalParams)) {
                throw new QlIllegalArgumentException("expects between " + NUM_NAMES[5 - numOptionalParams] + " and " + NUM_NAMES[5] + " arguments");
            }
            if (!hasOptionalParams && children.size() != 5) {
                throw new QlIllegalArgumentException("expects exactly " + NUM_NAMES[5] + " arguments");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, children.size() > 0 ? (Expression)children.get(0) : null, children.size() > 1 ? (Expression)children.get(1) : null, children.size() > 2 ? (Expression)children.get(2) : null, children.size() > 3 ? (Expression)children.get(3) : null, children.size() > 4 ? (Expression)children.get(4) : null);
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    protected static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, UnaryVariadicBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean hasMinimumOne = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumOne && children.size() < 1) {
                throw new QlIllegalArgumentException("expects at least one argument");
            }
            if (!hasMinimumOne && children.size() < 2) {
                throw new QlIllegalArgumentException("expects at least two arguments");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, (Expression)children.get(0), children.subList(1, children.size()));
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    protected static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, ConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (!children.isEmpty()) {
                throw new QlIllegalArgumentException("expects no arguments");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, cfg);
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    public static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, UnaryConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (children.size() > 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            Expression ex = children.size() == 1 ? (Expression)children.get(0) : null;
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, ex, cfg);
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    protected static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, BinaryConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean isBinaryOptionalParamFunction = OptionalArgument.class.isAssignableFrom(function);
            if (isBinaryOptionalParamFunction && (children.size() > 2 || children.size() < 1)) {
                throw new QlIllegalArgumentException("expects one or two arguments");
            }
            if (!isBinaryOptionalParamFunction && children.size() != 2) {
                throw new QlIllegalArgumentException("expects exactly two arguments");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, (Expression)children.get(0), children.size() == 2 ? (Expression)children.get(1) : null, cfg);
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    protected <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> FunctionDefinition def(Class<T> function, TernaryConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean hasMinimumTwo = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumTwo && (children.size() > 3 || children.size() < 2)) {
                throw new QlIllegalArgumentException("expects two or three arguments");
            }
            if (!hasMinimumTwo && children.size() != 3) {
                throw new QlIllegalArgumentException("expects exactly three arguments");
            }
            return (org.elasticsearch.xpack.esql.core.expression.function.Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() == 3 ? (Expression)children.get(2) : null, cfg);
        };
        return EsqlFunctionRegistry.def(function, builder, names);
    }

    private static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> BiFunction<Source, Expression, T> uni(BiFunction<Source, Expression, T> function) {
        return function;
    }

    private static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> BinaryBuilder<T> bi(BinaryBuilder<T> function) {
        return function;
    }

    private static <T extends org.elasticsearch.xpack.esql.core.expression.function.Function> TernaryBuilder<T> tri(TernaryBuilder<T> function) {
        return function;
    }

    static {
        List<DataType> typePriorityList = Arrays.asList(DataType.DATETIME, DataType.DOUBLE, DataType.LONG, DataType.INTEGER, DataType.IP, DataType.VERSION, DataType.GEO_POINT, DataType.GEO_SHAPE, DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE, DataType.BOOLEAN, DataType.UNSIGNED_LONG, DataType.UNSUPPORTED);
        dataTypeCastingPriority = new HashMap<DataType, Integer>();
        for (int i = 0; i < typePriorityList.size(); ++i) {
            dataTypeCastingPriority.put(typePriorityList.get(i), i);
        }
        NUM_NAMES = new String[]{"zero", "one", "two", "three", "four", "five"};
    }

    private static class SnapshotFunctionRegistry
    extends EsqlFunctionRegistry {
        SnapshotFunctionRegistry() {
            if (!Build.current().isSnapshot()) {
                throw new IllegalStateException("build snapshot function registry for non-snapshot build");
            }
            this.register(EsqlFunctionRegistry.snapshotFunctions());
        }
    }

    protected static interface QuaternaryBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Expression var5);
    }

    public static interface BinaryBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3);
    }

    protected static interface TernaryBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4);
    }

    protected static interface UnaryVariadicBuilder<T> {
        public T build(Source var1, Expression var2, List<Expression> var3);
    }

    public static interface UnaryConfigurationAwareBuilder<T> {
        public T build(Source var1, Expression var2, Configuration var3);
    }

    protected static interface BinaryConfigurationAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Configuration var4);
    }

    protected static interface ConfigurationAwareBuilder<T> {
        public T build(Source var1, Configuration var2);
    }

    public record FunctionDescription(String name, List<ArgSignature> args, String[] returnType, String description, boolean variadic, boolean isAggregation) {
        public List<String> argNames() {
            return this.args.stream().map(ArgSignature::name).toList();
        }

        public List<String> argDescriptions() {
            return this.args.stream().map(ArgSignature::description).toList();
        }
    }

    public record ArgSignature(String name, String[] type, String description, boolean optional, DataType targetDataType) {
        @Override
        public String toString() {
            return "ArgSignature{name='" + this.name + "', type=" + Arrays.toString(this.type) + ", description='" + this.description + "', optional=" + this.optional + ", targetDataType=" + this.targetDataType + "}";
        }
    }

    protected static interface FunctionBuilder {
        public org.elasticsearch.xpack.esql.core.expression.function.Function build(Source var1, List<Expression> var2, Configuration var3);
    }

    protected static interface NaryBuilder<T> {
        public T build(Source var1, List<Expression> var2);
    }

    protected static interface QuinaryBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Expression var5, Expression var6);
    }

    protected static interface TernaryConfigurationAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Configuration var5);
    }
}

