/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.execution;

import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.analysis.PreAnalyzer;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.Mapper;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.EsqlSession;
import org.elasticsearch.xpack.esql.session.IndexResolver;
import org.elasticsearch.xpack.esql.session.Result;
import org.elasticsearch.xpack.esql.stats.Metrics;
import org.elasticsearch.xpack.esql.stats.PlanningMetrics;
import org.elasticsearch.xpack.esql.stats.PlanningMetricsManager;
import org.elasticsearch.xpack.esql.stats.QueryMetric;

public class PlanExecutor {
    private final IndexResolver indexResolver;
    private final PreAnalyzer preAnalyzer;
    private final EsqlFunctionRegistry functionRegistry;
    private final Mapper mapper;
    private final Metrics metrics;
    private final Verifier verifier;
    private final PlanningMetricsManager planningMetricsManager;

    public PlanExecutor(IndexResolver indexResolver, MeterRegistry meterRegistry) {
        this.indexResolver = indexResolver;
        this.preAnalyzer = new PreAnalyzer();
        this.functionRegistry = new EsqlFunctionRegistry();
        this.mapper = new Mapper(this.functionRegistry);
        this.metrics = new Metrics();
        this.verifier = new Verifier(this.metrics);
        this.planningMetricsManager = new PlanningMetricsManager(meterRegistry);
    }

    public void esql(EsqlQueryRequest request, String sessionId, Configuration cfg, EnrichPolicyResolver enrichPolicyResolver, EsqlExecutionInfo executionInfo, IndicesExpressionGrouper indicesExpressionGrouper, BiConsumer<PhysicalPlan, ActionListener<Result>> runPhase, ActionListener<Result> listener) {
        PlanningMetrics planningMetrics = new PlanningMetrics();
        EsqlSession session = new EsqlSession(sessionId, cfg, this.indexResolver, enrichPolicyResolver, this.preAnalyzer, this.functionRegistry, new LogicalPlanOptimizer(new LogicalOptimizerContext(cfg)), this.mapper, this.verifier, planningMetrics, indicesExpressionGrouper);
        QueryMetric clientId = QueryMetric.fromString("rest");
        this.metrics.total(clientId);
        session.execute(request, executionInfo, runPhase, (ActionListener<Result>)ActionListener.wrap(x -> {
            this.planningMetricsManager.publish(planningMetrics, true);
            listener.onResponse(x);
        }, ex -> {
            this.metrics.failed(clientId);
            this.planningMetricsManager.publish(planningMetrics, false);
            listener.onFailure(ex);
        }));
    }

    public IndexResolver indexResolver() {
        return this.indexResolver;
    }

    public Metrics metrics() {
        return this.metrics;
    }
}

