/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.util.ArrayList;
import java.util.function.IntFunction;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownBinary;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;

abstract class QueryList {
    protected final Block block;

    protected QueryList(Block block) {
        this.block = block;
    }

    int getPositionCount() {
        return this.block.getPositionCount();
    }

    @Nullable
    abstract Query getQuery(int var1);

    static QueryList termQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, Block block, DataType inputDataType) {
        return new TermQueryList(field, searchExecutionContext, block, inputDataType);
    }

    static QueryList geoShapeQuery(MappedFieldType field, SearchExecutionContext searchExecutionContext, Block block, DataType inputDataType) {
        return new GeoShapeQueryList(field, searchExecutionContext, block, inputDataType);
    }

    private static class TermQueryList
    extends QueryList {
        private final BytesRef scratch = new BytesRef();
        private final byte[] ipBytes = new byte[16];
        private final MappedFieldType field;
        private final SearchExecutionContext searchExecutionContext;
        private final DataType inputDataType;
        private final IntFunction<Object> blockValueReader;

        private TermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, Block block, DataType inputDataType) {
            super(block);
            this.field = field;
            this.searchExecutionContext = searchExecutionContext;
            this.inputDataType = inputDataType;
            this.blockValueReader = this.blockToJavaObject();
        }

        @Override
        Query getQuery(int position) {
            int first = this.block.getFirstValueIndex(position);
            int count = this.block.getValueCount(position);
            return switch (count) {
                case 0 -> null;
                case 1 -> this.field.termQuery(this.blockValueReader.apply(first), this.searchExecutionContext);
                default -> {
                    ArrayList<Object> terms = new ArrayList<Object>(count);
                    for (int i = 0; i < count; ++i) {
                        Object value = this.blockValueReader.apply(first + i);
                        terms.add(value);
                    }
                    yield this.field.termsQuery(terms, this.searchExecutionContext);
                }
            };
        }

        private IntFunction<Object> blockToJavaObject() {
            return switch (this.block.elementType()) {
                default -> throw new IncompatibleClassChangeError();
                case ElementType.BOOLEAN -> {
                    BooleanBlock booleanBlock = (BooleanBlock)this.block;
                    yield arg_0 -> ((BooleanBlock)booleanBlock).getBoolean(arg_0);
                }
                case ElementType.BYTES_REF -> {
                    BytesRefBlock bytesRefBlock = (BytesRefBlock)this.block;
                    if (this.inputDataType == DataType.IP) {
                        yield offset -> {
                            BytesRef bytes = bytesRefBlock.getBytesRef(offset, this.scratch);
                            if (this.ipBytes.length != bytes.length) {
                                throw new IllegalStateException("Cannot decode IP field from bytes of length " + bytes.length);
                            }
                            System.arraycopy(bytes.bytes, bytes.offset, this.ipBytes, 0, bytes.length);
                            return InetAddressPoint.decode((byte[])this.ipBytes);
                        };
                    }
                    yield offset -> bytesRefBlock.getBytesRef(offset, new BytesRef());
                }
                case ElementType.DOUBLE -> {
                    DoubleBlock doubleBlock = (DoubleBlock)this.block;
                    yield arg_0 -> ((DoubleBlock)doubleBlock).getDouble(arg_0);
                }
                case ElementType.FLOAT -> {
                    FloatBlock floatBlock = (FloatBlock)this.block;
                    yield arg_0 -> ((FloatBlock)floatBlock).getFloat(arg_0);
                }
                case ElementType.INT -> {
                    IntBlock intBlock = (IntBlock)this.block;
                    yield arg_0 -> ((IntBlock)intBlock).getInt(arg_0);
                }
                case ElementType.LONG -> {
                    MappedFieldType var3_7;
                    LongBlock longBlock = (LongBlock)this.block;
                    if (this.inputDataType == DataType.DATETIME && (var3_7 = this.field) instanceof RangeFieldMapper.RangeFieldType) {
                        RangeFieldMapper.RangeFieldType rangeFieldType = (RangeFieldMapper.RangeFieldType)var3_7;
                        yield offset -> rangeFieldType.dateTimeFormatter().formatMillis(longBlock.getLong(offset));
                    }
                    yield arg_0 -> ((LongBlock)longBlock).getLong(arg_0);
                }
                case ElementType.NULL -> offset -> null;
                case ElementType.DOC -> throw new EsqlIllegalArgumentException("can't read values from [doc] block");
                case ElementType.COMPOSITE -> throw new EsqlIllegalArgumentException("can't read values from [composite] block");
                case ElementType.UNKNOWN -> throw new EsqlIllegalArgumentException("can't read values from [" + this.block + "]");
            };
        }
    }

    private static class GeoShapeQueryList
    extends QueryList {
        private final BytesRef scratch = new BytesRef();
        private final MappedFieldType field;
        private final SearchExecutionContext searchExecutionContext;
        private final IntFunction<Geometry> blockValueReader;
        private final DataType inputDataType;
        private final IntFunction<Query> shapeQuery;

        private GeoShapeQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, Block block, DataType inputDataType) {
            super(block);
            this.field = field;
            this.searchExecutionContext = searchExecutionContext;
            this.inputDataType = inputDataType;
            this.blockValueReader = this.blockToGeometry(block);
            this.shapeQuery = this.shapeQuery();
        }

        @Override
        Query getQuery(int position) {
            int first = this.block.getFirstValueIndex(position);
            int count = this.block.getValueCount(position);
            return switch (count) {
                case 0 -> null;
                case 1 -> this.shapeQuery.apply(first);
                default -> throw new EsqlIllegalArgumentException("can't read multiple Geometry values from a single position");
            };
        }

        private IntFunction<Geometry> blockToGeometry(Block block) {
            return switch (block.elementType()) {
                case ElementType.LONG -> offset -> {
                    long encoded = ((LongBlock)block).getLong(offset);
                    return SpatialCoordinateTypes.GEO.longAsPoint(encoded);
                };
                case ElementType.BYTES_REF -> offset -> {
                    BytesRef wkb = ((BytesRefBlock)block).getBytesRef(offset, this.scratch);
                    return WellKnownBinary.fromWKB((GeometryValidator)GeometryValidator.NOOP, (boolean)false, (byte[])wkb.bytes, (int)wkb.offset, (int)wkb.length);
                };
                case ElementType.NULL -> offset -> null;
                default -> throw new EsqlIllegalArgumentException("can't read Geometry values from [" + block.elementType() + "] block");
            };
        }

        private IntFunction<Query> shapeQuery() {
            MappedFieldType mappedFieldType = this.field;
            if (mappedFieldType instanceof GeoShapeQueryable) {
                GeoShapeQueryable geoShapeQueryable = (GeoShapeQueryable)mappedFieldType;
                return offset -> geoShapeQueryable.geoShapeQuery(this.searchExecutionContext, this.field.name(), ShapeRelation.INTERSECTS, this.blockValueReader.apply(offset));
            }
            throw new IllegalArgumentException("Unsupported field type for geo_match ENRICH: " + this.field.typeName());
        }
    }
}

